<?php

namespace Controllers;

use baseKRIZAN\Security\Authentication;
use baseKRIZAN\Session\SessionManager;
use baseKRIZAN\Validation\Validator;
use Models\DatabaseTable;
use baseKRIZAN\Database\DatabaseConnection;
use baseKRIZAN\Error\Logger;
use baseKRIZAN\Http\Request;
use baseKRIZAN\Http\Response;

class CMS extends BaseController
{
    protected DatabaseTable $korisniciTable;
    protected DatabaseConnection $databaseConnection;
    protected Validator $validator;

    public function __construct(
        DatabaseTable $korisniciTable,
        Authentication $authentication,
        DatabaseConnection $databaseConnection,
        Validator $validator,
        Logger $logger,
        ?SessionManager $sessionManager = null
    ) {
        parent::__construct($logger, $sessionManager, $authentication);
        $this->korisniciTable = $korisniciTable;
        $this->databaseConnection = $databaseConnection;
        $this->validator = $validator;
    }

    public function cms(): Response
    {
        $user = $this->authentication->getUser();
        
        return $this->response()->render(
            'CMS/cms.html.php',
            [
                'korisnik' => $user,
                'conn' => $this->databaseConnection->getPDO()
            ],
            'CMS'
        );
    }
}