<?php
// excelexport.php

function excelexport(string $type, array $columns, string $filename, array $data): array {
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    
    // Set headers
    foreach ($columns as $index => $column) {
        $sheet->setCellValue(chr(65 + $index) . '1', $column);
    }
    
    // Set data
    $row = 2;
    foreach ($data as $item) {
        foreach ($columns as $index => $column) {
            $sheet->setCellValue(chr(65 + $index) . $row, $item->$column ?? '');
        }
        $row++;
    }
    
    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    
    ob_start();
    $writer->save('php://output');
    $content = ob_get_clean();
    
    return [
        'content' => $content,
        'filename' => $filename . '.xlsx'
    ];
}