<?php

namespace Models\Entity;

use Models\DatabaseTable;

class Korisnik
{
    const KORISNIK_test = 1;
    const KORISNIK_vanjski = 2;
    const KORISNIK_tasks_tehnicar = 4;
    const KORISNIK_tasks_team_leader = 8;
    const KORISNIK_tasks_voditelj = 16;
    const KORISNIK_sales_agent = 32;
    const KORISNIK_sales_kontrolor = 64;
    const KORISNIK_sales_administrator = 128;
    const KORISNIK_sales_supervisor = 256;
    const KORISNIK_ADMIN = 512;
    const KORISNIK_MASTER = 1024;

    private $notificationsTable;

    public $id;
    public $date_created;
    public $registration_ip;
    public $user_email;
    public $user_firstandlastname;
    public $user_address;
    public $user_company;
    public $user_role;
    public $user_password;
    public $user_permissions;
    public $user_modules;
    public $user_lastlogin;
    public $email_verified;
    public $verification_token;
    public $verification_expires;
    
    // New fields for tracking logins and resetting passwords
    public $failed_login_attempts = 0;
    public $last_failed_login;
    public $password_reset_token;
    public $password_reset_expires;

    public function __construct(DatabaseTable $notificationsTable)
    {
        $this->notificationsTable = $notificationsTable;
    }

    public function hasPermission($permission): bool
    {
        return ($this->user_permissions & $permission) === $permission;
    }
    
    public function hasMinimumPermission($minimumPermission): bool
    {
        // Check if user has at least this level of permission
        return $this->user_permissions >= $minimumPermission;
    }
}