<?php

namespace baseKRIZAN\Assets\Processor;

use baseKRIZAN\Error\Logger;

/**
 * Abstract Asset Processor
 * 
 * Base implementation for asset processors with common functionality.
 */
abstract class AbstractProcessor implements ProcessorInterface
{
    protected ?Logger $logger = null;
    
    /**
     * Set logger
     */
    public function setLogger(?Logger $logger): void
    {
        $this->logger = $logger;
    }
    
    /**
     * Log a message if logger is available
     */
    protected function log(string $level, string $message): void
    {
        if ($this->logger) {
            switch ($level) {
                case 'debug':
                    $this->logger->assets($message);
                    break;
                case 'info':
                    $this->logger->assets($message);
                    break;
                case 'warning':
                    $this->logger->assets($message);
                    break;
                case 'error':
                    $this->logger->error($message);
                    break;
                default:
                    $this->logger->assets($message);
            }
        }
    }
}