<?php

namespace baseKRIZAN\Assets\Processor;

/**
 * Asset Processor Interface
 * 
 * Defines the contract for asset processors in the pipeline.
 */
interface ProcessorInterface
{
    /**
     * Process an asset
     * 
     * @param string $assetPath Path to the asset
     * @param array $options Processing options
     * @return string|null New asset path if changed, null to use the original
     */
    public function process(string $assetPath, array $options = []): ?string;
}