<?php

namespace baseKRIZAN\Assets\Strategy;

use baseKRIZAN\Error\Logger;

/**
 * Asset Strategy Interface
 * 
 * Defines the interface for asset type-specific strategies.
 */
interface AssetStrategyInterface
{
    /**
     * Determine if this strategy can handle the given asset path
     */
    public function canHandle(string $file, ?string $module = null): bool;
    
    /**
     * Process an asset path for this specific asset type
     */
    public function processAssetPath(string $file, ?string $module = null): string;
    
    /**
     * Get the source path for this asset type
     */
    public function getSourcePath(?string $module = null): string;
    
    /**
     * Get the cache path for this asset type
     */
    public function getCachePath(?string $module = null): string;
    
    /**
     * Get the public path for this asset type
     */
    public function getPublicPath(?string $module = null): string;
    
    /**
     * Compile assets of this type for production
     */
    public function compileForProduction(array &$manifest): array;
    
    /**
     * Set logger for this strategy
     */
    public function setLogger(?Logger $logger): void;
}