<?php

namespace baseKRIZAN\BORNA\Interfaces;

/**
 * Interface for security analyzers
 */
interface AnalyzerInterface
{
    /**
     * Analyze request data for security threats
     * 
     * @param array $requestData Request data to analyze
     * @return array Analysis result with score and description
     */
    public function analyze(array $requestData): array;
    
    /**
     * Get analyzer name
     * 
     * @return string Analyzer name
     */
    public function getName(): string;
    
    /**
     * Set security level
     * 
     * @param int $level Security level (1-3)
     */
    public function setSecurityLevel(int $level): void;
    
    /**
     * Get analyzer statistics
     * 
     * @return array Statistics data
     */
    public function getStatistics(): array;
}