<?php
// app/baseKRIZAN/Bootstrap/Initializers/ApplicationInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Http\EntryPoint;

/**
 * Initializer for final application components
 */
class ApplicationInitializer extends Initializer
{
    /**
     * Initializes final application components
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Register EntryPoint
        $this->container->register('entryPoint', function($container) {
            $request = $container->get('request');
            
            return new EntryPoint(
                $request->getPath(),
                $request->getMethod() ?? 'GET',
                $container->get('routes'),
                $container
            );
        }, 'request');
        
        $logger->bootstrap('Bootstrap components registered');
    }
    
    /**
     * Final application initialization
     * 
     * @return void
     */
    public function finalize(): void
    {
        $logger = $this->getLogger();
        
        // Log basic services available after bootstrap
        $services = array_keys($this->container->getServices());
        $logger->bootstrap('Bootstrap completed with registered services', [
            'service_count' => count($services),
            'critical_services' => array_filter($services, function($service) {
                return in_array($service, [
                    'logger', 'pdo', 'sessionManager', 'authentication', 
                    'errorHandler', 'templateRenderer', 'validator'
                ]);
            })
        ]);
        
        // Trigger bootstrap completion event if EventDispatcher is available
        if ($this->container->has('eventDispatcher')) {
            $eventDispatcher = $this->container->get('eventDispatcher');
            $eventDispatcher->dispatch('app.bootstrap.completed', [
                'container' => $this->container
            ]);
        }
    }
}