<?php
// app/baseKRIZAN/Bootstrap/Initializers/AssetInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

/**
 * Initializer for asset management
 */
class AssetInitializer extends Initializer
{
    /**
     * Initializes asset management components
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Register AssetManager
        if (class_exists('\\baseKRIZAN\\Assets\\AssetManager')) {
            $this->container->register('assetManager', function($container) use ($logger) {
                // Reset AssetPathResolver in case it was already initialized
                \baseKRIZAN\Assets\AssetPathResolver::reset();
                
                // Initialize PathResolver with logger
                $pathResolver = \baseKRIZAN\Assets\AssetPathResolver::getInstance($logger);
                
                // Check if paths were correctly loaded
                $configuredSrcPath = \baseKRIZAN\Config\Config::get('paths.srcassets');
                $resolverSrcPath = \baseKRIZAN\Assets\AssetPathResolver::getSrcAssetsSourcePath();
                
                // If there's a mismatch, reload paths
                if (strpos($resolverSrcPath, '/assets') !== false && strpos($configuredSrcPath, '/assets') === false) {
                    $logger->bootstrap("Path mismatch detected - reloading AssetPathResolver paths");
                    $pathResolver->reloadPaths();
                }
                
                // Get AssetManager singleton instance
                return \baseKRIZAN\Assets\AssetManager::getInstance($logger);
            });
            
            $logger->bootstrap('Asset management system registered');
        } else {
            $logger->bootstrap('Asset management system classes not found');
        }
    }
}