<?php
// app/baseKRIZAN/Bootstrap/Initializers/CacheInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Cache\CacheManager;
use baseKRIZAN\Cache\FileCache;

/**
 * Initializer for caching system
 */
class CacheInitializer extends Initializer
{
    /**
     * Initializes caching components
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        try {
            // Register cache manager
            $this->container->register('cache', function($container) use ($logger) {
                $cacheManager = CacheManager::getInstance($logger);
                
                // Register additional drivers if needed
                // $cacheManager->registerDriver('redis', new RedisCache(...));
                
                return $cacheManager;
            }, 'singleton');
            
            $logger->bootstrap('Cache system initialized', [
                'default_driver' => \baseKRIZAN\Config\Config::get('cache.default', 'file')
            ]);
        } catch (\Throwable $e) {
            $logger->error('Failed to initialize cache system', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    }
}