<?php
// app/baseKRIZAN/Bootstrap/Initializers/ConfigurationInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

/**
 * Initializer for application configuration
 */
class ConfigurationInitializer extends Initializer
{
    /**
     * Initializes application configuration
     * 
     * @return void
     */
    public function initialize(): void
    {
        // Load configuration files
        \baseKRIZAN\Config\Config::load([
            APP_ROOT . '/app/config/env_config.php',
        ]);
        
        // Register configuration in container
        $this->container->register('config', \baseKRIZAN\Config\Config::class);
        
        // Development environment settings
        $developmentMode = \baseKRIZAN\Config\Config::get('environment') === "development";
        if (!defined('DEVELOPMENT_MODE')) {
            define('DEVELOPMENT_MODE', $developmentMode);
        }
    }
}