<?php
// app/baseKRIZAN/Bootstrap/Initializers/DatabaseInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Database\DatabaseConnection;

/**
 * Initializer for database
 * 
 * This initializer is responsible for initializing and registering
 * DatabaseConnection instance in the container, ensuring that
 * only one instance is used throughout the application.
 */
class DatabaseInitializer extends Initializer
{
    /**
     * Initializes database services
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        try {
            // Register dbConnection
            $this->container->register('dbConnection', function($container) use ($logger) {
                // Get singleton instance
                $dbConnection = DatabaseConnection::getInstance();
                
                // Set event dispatcher and logger if available
                if ($container->has('eventDispatcher')) {
                    $dbConnection->setServices(
                        $container->get('eventDispatcher'),
                        $logger
                    );
                } else {
                    $dbConnection->setServices(null, $logger);
                }
                
                return $dbConnection;
            }, 'singleton');
            
            // Also register PDO for components that directly need it
            $this->container->register('pdo', function($container) {
                return $container->get('dbConnection')->getPDO();
            }, 'singleton');
            
            $logger->bootstrap('Database services registered successfully');
        } catch (\Throwable $e) {
            $logger->error('Failed to register database services', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            // Re-throw exception
            throw $e;
        }
    }
}