<?php
// app/baseKRIZAN/Bootstrap/Initializers/DependencyInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

/**
 * Initializer for loading application dependencies
 */
class DependencyInitializer extends Initializer
{
    /**
     * Initializes basic application dependencies
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        try {
            // Load base dependencies
            $this->loadBaseDependencies($logger);
            
            $logger->bootstrap('Dependencies loaded successfully');
        } catch (\Throwable $e) {
            $logger->error('Failed to load dependencies', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    }
    
    /**
     * Loads application base dependencies
     * 
     * @param mixed $logger Logger for logging
     * @return void
     */
    private function loadBaseDependencies($logger): void
    {
        $logger->bootstrap('Loading base dependencies');
        
        $baseDependenciesFile = \baseKRIZAN\Config\Config::get('paths.config') . '/app_basedependencies.php';
        
        if (file_exists($baseDependenciesFile)) {
            try {
                $dependenciesLoader = include $baseDependenciesFile;
                
                if (is_callable($dependenciesLoader)) {
                    $dependenciesLoader($this->container);
                    $logger->bootstrap('Base dependencies loaded successfully');
                } else {
                    $logger->error('Base dependencies file did not return a callable function');
                }
            } catch (\Throwable $e) {
                $logger->error('Failed to load base dependencies', [
                    'error' => $e->getMessage(),
                    'trace' => $e->getTraceAsString()
                ]);
            }
        } else {
            $logger->warning('Base dependencies file not found', [
                'file' => $baseDependenciesFile
            ]);
        }
    }
}