<?php
// app/baseKRIZAN/Bootstrap/Initializers/EnvironmentInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

/**
 * Initializer for application environment
 * This is the basic initializer that is always loaded first
 */
class EnvironmentInitializer extends Initializer
{
    /**
     * Initializes basic application environment
     * 
     * @return void
     */
    public function initialize(): void
    {
        // Load .env file before anything else
        $dotenvPath = APP_ROOT . '/app/config/';
        
        if (file_exists($dotenvPath . '.env')) {
            $dotenv = \Dotenv\Dotenv::createImmutable($dotenvPath);
            $dotenv->load();
        }
        
        // Define global functions
        $this->defineGlobalFunctions();
    }
    
    /**
     * Defines global helper functions
     * 
     * @return void
     */
    private function defineGlobalFunctions(): void
    {
        // Load global functions if file exists
        $initEnvFile = APP_ROOT . '/app/baseKRIZAN/Bootstrap/initEnvironment.php';
        if (file_exists($initEnvFile)) {
            require_once $initEnvFile;
        }
    }
}