<?php
// app/baseKRIZAN/Bootstrap/Initializers/EventInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

/**
 * Initializer for event system
 */
class EventInitializer extends Initializer
{
    /**
     * Initializes event dispatcher in container
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Create and register EventDispatcher
        if (class_exists('\\baseKRIZAN\\Events\\EventDispatcher')) {
            $this->container->register('eventDispatcher', function($container) use ($logger) {
                return new \baseKRIZAN\Events\EventDispatcher($logger);
            }, 'singleton');
            
            $logger->bootstrap('Event system initialized');
        } else {
            $logger->bootstrap('Event system classes not found');
        }
    }
}