<?php
// app/baseKRIZAN/Bootstrap/Initializers/RouteInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Routing\RouteBuilder;
use baseKRIZAN\Routing\Router;

/**
 * Initializer for routing system
 */
class RouteInitializer extends Initializer
{
    /**
     * Initializes routing components
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Register RouteBuilder
        $this->container->register('routeBuilder', function($container) {
            return new RouteBuilder();
        });
        
        // Register Router
        $this->container->register('routes', function($container) use ($logger) {
            return new Router($logger, $container);
        });
        
        // Register UrlGenerator - DODAJTE OVAJ DIO
        $this->container->register('urlGenerator', function($container) use ($logger) {
            return new \baseKRIZAN\Routing\UrlGenerator(
                $container->get('routes'),
                $logger
            );
        });
        
        $logger->bootstrap('Routing system registered');
        $logger->bootstrap('UrlGenerator registered'); // DODAJTE OVU LINIJU
    }
    
    /**
     * Loads routes and initializes router after all components are available
     * 
     * @return void
     */
    public function finalize(): void
    {
        $logger = $this->getLogger();
        $builder = $this->container->get('routeBuilder');
        
        // Load base routes
        $this->loadBaseRoutes($builder, $logger);
        
        // Get all defined routes
        $routes = $builder->getRoutes();
        
        // Set routes in Router
        $router = $this->container->get('routes');
        if (method_exists($router, 'setRoutes')) {
            $router->setRoutes($routes);
            $logger->bootstrap('Routes registered with Router');
        }
        
        $logger->bootstrap('Routing system initialized');
    }
    
    /**
     * Loads application base routes
     * 
     * @param RouteBuilder $builder Builder for route definition
     * @param mixed $logger Logger for logging
     * @return void
     */
    private function loadBaseRoutes(RouteBuilder $builder, $logger): void
    {
        $baseRoutesFile = \baseKRIZAN\Config\Config::get('paths.config') . '/app_baseroutes.php';
        
        if (file_exists($baseRoutesFile)) {
            try {
                $container = $this->container;
                
                // Load routes
                include($baseRoutesFile);
                
                // Detailed route logging
                $routes = $builder->getRoutes();
                
                $logger->bootstrap('Routes Loaded', [
                    'route_count' => count($routes),
                    'routes' => array_keys($routes)
                ]);
                
                $logger->bootstrap('Base routes loaded successfully');
            } catch (\Throwable $e) {
                $logger->error('Failed to load base routes', [
                    'error' => $e->getMessage(),
                    'trace' => $e->getTraceAsString()
                ]);
            }
        } else {
            $logger->bootstrap('Base routes file not found', [
                'file' => $baseRoutesFile
            ]);
        }
    }
}