<?php
// app/baseKRIZAN/Bootstrap/Initializers/SessionInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Session\SessionManager;

/**
 * Initializer for session management
 */
class SessionInitializer extends Initializer
{
    /**
     * Initializes session and related components
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Register SessionManager
        $this->container->register('sessionManager', function($container) use ($logger) {
            return new SessionManager($logger);
        });
        
        // CSRF protection moved to SecurityInitializer
        $logger->bootstrap('Session manager registered');
    }
    
    /**
     * Session initialization
     * 
     * @return void
     */
    public function finalize(): void
    {
        $sessionManager = $this->container->get('sessionManager');
        $logger = $this->getLogger();
        
        // Start session only if needed
        $sessionManager->ensureSessionIntegrity();
        
        // Log session initialization
        $logger->bootstrap('Session initialization completed', [
            'session_status' => session_status() === PHP_SESSION_ACTIVE ? 'active' : 'inactive'
        ]);
    }
}