<?php
// app/baseKRIZAN/Bootstrap/Initializers/ValidationInitializer.php

namespace baseKRIZAN\Bootstrap\Initializers;

use baseKRIZAN\Validation\Validator;

/**
 * Initializer za validacijski sustav
 */
class ValidationInitializer extends Initializer
{
    /**
     * Inicijalizira validacijski sustav
     * 
     * @return void
     */
    public function initialize(): void
    {
        $logger = $this->getLogger();
        
        // Registriraj Validator u container
        $this->container->register('validator', function($container) use ($logger) {
            return new Validator($logger);
        }, 'singleton');
        
        $logger->bootstrap('Validation system registered');
    }
    
    /**
     * Finalizira inicijalizaciju validacijskog sustava
     * 
     * @return void
     */
    public function finalize(): void
    {
        $logger = $this->getLogger();
        
        // Ako postoji validationRulesService (može biti registriran u app_basedependencies.php)
        if ($this->container->has('validationRulesService')) {
            $logger->bootstrap('Using validationRulesService for rules registration');
        } else {
            $logger->bootstrap('ValidationRulesService not found, validation rules need to be registered manually');
        }
        
        $logger->bootstrap('Validation system finalized');
    }
}