<?php
// app/baseKRIZAN/Bootstrap/initEnvironment.php

// First define global functions
namespace {
    /**
     * Retrieves value from environment variable with safe typing
     * 
     * @param string $key Variable key
     * @param mixed $default Default value
     * @return mixed Variable value
     */
    if (!function_exists('env')) {
        function env(string $key, $default = null) {
            $value = $_ENV[$key] ?? $_SERVER[$key] ?? false;
            
            if ($value === false) {
                return $default;
            }
            
            // Type conversion
            switch (strtolower($value)) {
                case 'true':
                case '(true)':
                    return true;
                case 'false':
                case '(false)':
                    return false;
                case 'empty':
                case '(empty)':
                    return '';
                case 'null':
                case '(null)':
                    return null;
            }
            
            // Support for quoted values in .env file
            if (preg_match('/\A([\'"])(.*)\1\z/', $value, $matches)) {
                return $matches[2];
            }

            return $value;
        }
    }

    /**
     * Safely generates cryptographically strong key
     */
    if (!function_exists('generate_key')) {
        function generate_key(int $length = 32): string {
            return bin2hex(random_bytes($length));
        }
    }

    /**
     * Gets application path
     */
    if (!function_exists('app_path')) {
        function app_path(string $path = ''): string {
            return $path ? APP_ROOT . '/' . ltrim($path, '/') : APP_ROOT;
        }
    }

    // Učitavanje helpers.php
    $helpersFile = APP_ROOT . '/app/baseKRIZAN/helpers.php'; // Prilagodite putanju ako je drugačija
    if (file_exists($helpersFile)) {
        require_once $helpersFile;
    }
}

// After global functions we can define namespace
namespace baseKRIZAN\Bootstrap {
    // Code specific to namespace baseKRIZAN\Bootstrap
    // If there's no code specific to namespace, this can remain empty
}