<?php
// app/baseKRIZAN/Error/LoggerInterface.php

namespace baseKRIZAN\Error;

use Stringable;

/**
 * Sučelje za različite implementacije loggera
 * 
 * Pruža dodatne metode iznad PSR-3 standarda za naprednije logiranje
 */
interface LoggerInterface
{
    /**
     * Emergency level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function emergency(string|Stringable $message, array $context = []): void;
    
    /**
     * Alert level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function alert(string|Stringable $message, array $context = []): void;
    
    /**
     * Critical level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function critical(string|Stringable $message, array $context = []): void;
    
    /**
     * Error level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function error(string|Stringable $message, array $context = []): void;
    
    /**
     * Warning level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function warning(string|Stringable $message, array $context = []): void;
    
    /**
     * Notice level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function notice(string|Stringable $message, array $context = []): void;
    
    /**
     * Info level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function info(string|Stringable $message, array $context = []): void;
    
    /**
     * Debug level logiranje
     *
     * @param string|Stringable $message
     * @param array $context
     * @return void
     */
    public function debug(string|Stringable $message, array $context = []): void;
    
    /**
     * Provjera je li debug logiranje omogućeno
     *
     * @return bool
     */
    public function isDebugEnabled(): bool;
    
    /**
     * Logiranje u specifičnu kategoriju
     *
     * @param string $category Kategorija
     * @param string|Stringable $message Poruka
     * @param array $context Kontekst
     * @param string|null $level Opcionalni level (override)
     * @return void
     */
    public function logToCategory(string $category, string|Stringable $message, array $context = [], ?string $level = null): void;
}