<?php
// app/baseKRIZAN/Error/NotFoundException.php

namespace baseKRIZAN\Error;

/**
 * Iznimka za 404 Not Found greške
 */
class NotFoundException extends BaseException
{
    /**
     * Konstruktor
     * 
     * @param string $message Poruka o grešci
     * @param string $resource Tip resursa koji nije pronađen
     * @param mixed $identifier Identifikator resursa
     * @param \Throwable|null $previous Prethodna iznimka
     */
    public function __construct(
        string $message = "Resource not found",
        string $resource = 'page',
        mixed $identifier = null,
        ?\Throwable $previous = null
    ) {
        $context = [
            'resource_type' => $resource,
            'resource_id' => $identifier
        ];
        
        parent::__construct(
            $message,
            404,
            $previous,
            ExceptionType::ROUTING,
            404,
            $context,
            true // 404 je javna greška
        );
    }
    
    /**
     * Kreira iznimku za 404 Not Found za rutu
     * 
     * @param string $path Putanja koja nije pronađena
     * @return self
     */
    public static function forRoute(string $path): self
    {
        return new self(
            "Page not found: {$path}",
            'route',
            $path
        );
    }
    
    /**
     * Kreira iznimku za 404 Not Found za model/entitet
     * 
     * @param string $modelName Naziv modela
     * @param mixed $id Identifikator
     * @return self
     */
    public static function forModel(string $modelName, mixed $id): self
    {
        return new self(
            "{$modelName} with ID {$id} not found",
            $modelName,
            $id
        );
    }
}