<?php
// app/baseKRIZAN/Error/ValidationException.php

namespace baseKRIZAN\Error;

/**
 * Iznimka za greške validacije korisničkog unosa
 */
class ValidationException extends BaseException
{
    /**
     * Lista validation grešaka
     * @var array
     */
    private array $validationErrors;
    
    /**
     * Konstruktor
     * 
     * @param array $validationErrors Lista validation grešaka
     * @param string $message Poruka o grešci
     * @param int $code Kod greške
     * @param \Throwable|null $previous Prethodna iznimka
     * @param array $context Dodatni podaci za logiranje
     */
    public function __construct(
        array $validationErrors,
        string $message = "Validation failed",
        int $code = 0,
        ?\Throwable $previous = null,
        array $context = []
    ) {
        $this->validationErrors = $validationErrors;
        
        parent::__construct(
            $message,
            $code,
            $previous,
            ExceptionType::VALIDATION,
            400,
            array_merge($context, ['validation_errors' => $validationErrors]),
            true // Validation errors su javne
        );
    }
    
    /**
     * Dohvaća listu validation grešaka
     * 
     * @return array Lista validation grešaka
     */
    public function getValidationErrors(): array
    {
        return $this->validationErrors;
    }
    
    /**
     * Kreira iznimku iz validation rezultata
     * 
     * @param mixed $validationResult Rezultat validacije
     * @return self
     */
    public static function fromValidationResult($validationResult): self
    {
        $errors = [];
        
        // Ako je objekt koji ima errors metodu ili property
        if (is_object($validationResult) && (method_exists($validationResult, 'errors') || property_exists($validationResult, 'errors'))) {
            $errors = method_exists($validationResult, 'errors') ? $validationResult->errors() : $validationResult->errors;
        } 
        // Ako je asocijativni array s errors ključem
        elseif (is_array($validationResult) && isset($validationResult['errors'])) {
            $errors = $validationResult['errors'];
        }
        // Ako je direktno array grešaka
        elseif (is_array($validationResult)) {
            $errors = $validationResult;
        }
        
        return new self($errors);
    }
}