<?php
// app/baseKRIZAN/Events/Event.php

namespace baseKRIZAN\Events;

/**
 * Osnovna implementacija događaja
 * 
 * @package baseKRIZAN\Events
 */
class Event implements EventInterface
{
    /**
     * @var string Ime događaja
     */
    private string $name;
    
    /**
     * @var array Podaci događaja
     */
    private array $data;
    
    /**
     * @var bool Je li propagacija zaustavljena
     */
    private bool $propagationStopped = false;
    
    /**
     * Konstruktor
     * 
     * @param string $name Ime događaja
     * @param array $data Podaci događaja
     */
    public function __construct(string $name, array $data = [])
    {
        $this->name = $name;
        $this->data = $data;
    }
    
    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return $this->name;
    }
    
    /**
     * @inheritDoc
     */
    public function getData(): array
    {
        return $this->data;
    }
    
    /**
     * @inheritDoc
     */
    public function get(string $key, $default = null)
    {
        return $this->data[$key] ?? $default;
    }
    
    /**
     * @inheritDoc
     */
    public function set(string $key, $value): self
    {
        $this->data[$key] = $value;
        return $this;
    }
    
    /**
     * @inheritDoc
     */
    public function stopPropagation(): self
    {
        $this->propagationStopped = true;
        return $this;
    }
    
    /**
     * @inheritDoc
     */
    public function isPropagationStopped(): bool
    {
        return $this->propagationStopped;
    }
}