<?php
// app/baseKRIZAN/Events/EventInterface.php

namespace baseKRIZAN\Events;

/**
 * Sučelje za događaje
 * 
 * @package baseKRIZAN\Events
 */
interface EventInterface
{
    /**
     * Dohvaća ime događaja
     * 
     * @return string
     */
    public function getName(): string;
    
    /**
     * Dohvaća podatke događaja
     * 
     * @return array
     */
    public function getData(): array;
    
    /**
     * Dohvaća specificiranu vrijednost iz podataka
     * 
     * @param string $key Ključ
     * @param mixed $default Zadana vrijednost
     * @return mixed
     */
    public function get(string $key, $default = null);
    
    /**
     * Postavlja vrijednost u podatke
     * 
     * @param string $key Ključ
     * @param mixed $value Vrijednost
     * @return self
     */
    public function set(string $key, $value): self;
    
    /**
     * Zaustavlja propagaciju događaja
     * 
     * @return self
     */
    public function stopPropagation(): self;
    
    /**
     * Provjerava je li propagacija zaustavljena
     * 
     * @return bool
     */
    public function isPropagationStopped(): bool;
}