<?php

namespace baseKRIZAN\Http\Middleware;

use baseKRIZAN\Http\Request;
use baseKRIZAN\Http\Response;
use baseKRIZAN\Error\Logger;

/**
 * Base class for all middleware components.
 */
abstract class Middleware implements MiddlewareInterface
{
    /**
     * Middleware priority (lower number = higher priority)
     */
    protected int $priority = 100;
    
    /**
     * Logger instance
     */
    protected ?Logger $logger;
    
    /**
     * Constructor
     */
    public function __construct(?Logger $logger = null)
    {
        $this->logger = $logger;
    }
    
    /**
     * @inheritDoc
     */
    public function getPriority(): int
    {
        return $this->priority;
    }
    
    /**
     * @inheritDoc
     */
    public function terminate(Request $request, Response $response): void
    {
        // Default implementation does nothing
        // Subclasses can override this method if they need resource cleanup
    }
}