<?php

namespace baseKRIZAN\Http\Middleware;

use baseKRIZAN\Http\Request;
use baseKRIZAN\Http\Response;

/**
 * Base interface for all middleware components.
 */
interface MiddlewareInterface
{
    /**
     * Process request through middleware.
     * 
     * @param Request $request Request to process
     * @param callable $next Next middleware in chain
     * @return Response Response
     */
    public function process(Request $request, callable $next): Response;
    
    /**
     * Get middleware priority. Lower value = higher priority.
     * 
     * @return int Priority
     */
    public function getPriority(): int;
    
    /**
     * Optional resource cleanup after execution.
     * 
     * @param Request $request Request
     * @param Response $response Response
     * @return void
     */
    public function terminate(Request $request, Response $response): void;
}