<?php
// app/baseKRIZAN/Modules/ModuleEvents.php

namespace baseKRIZAN\Modules;

/**
 * Klasa s konstantama za događaje vezane uz module
 * 
 * @package baseKRIZAN\Modules
 */
class ModuleEvents
{
    /**
     * Događaj koji se emitira kada je modul uspješno registriran
     */
    public const REGISTERED = 'module.registered';
    
    /**
     * Događaj koji se emitira kada je modul uspješno aktiviran
     */
    public const ACTIVATED = 'module.activated';
    
    /**
     * Događaj koji se emitira kada je modul uspješno deaktiviran
     */
    public const DEACTIVATED = 'module.deactivated';
    
    /**
     * Događaj koji se emitira kada je modul uspješno učitan
     */
    public const LOADED = 'module.loaded';
    
    /**
     * Događaj koji se emitira kada su svi moduli učitani
     */
    public const ALL_LOADED = 'modules.all_loaded';
    
    /**
     * Događaj koji se emitira kada je bootstrapping modula završio
     */
    public const BOOTSTRAPPED = 'module.bootstrapped';
}