<?php
// app/baseKRIZAN/Modules/ModuleEventsListener.php

namespace baseKRIZAN\Modules;

use baseKRIZAN\Events\EventInterface;
use baseKRIZAN\Error\Logger;

/**
 * Primjer slušatelja događaja za module
 * 
 * @package baseKRIZAN\Modules
 */
class ModuleEventsListener
{
    /**
     * @var Logger
     */
    private Logger $logger;
    
    /**
     * Konstruktor
     * 
     * @param Logger $logger
     */
    public function __construct(Logger $logger)
    {
        $this->logger = $logger;
    }
    
    /**
     * Slušatelj za događaj aktivacije modula
     * 
     * @param EventInterface $event
     */
    public function onModuleActivated(EventInterface $event): void
    {
        $moduleId = $event->get('id');
        $moduleName = $event->get('name');
        $moduleVersion = $event->get('version');
        
        $this->logger->modules('Module activation event received', [
            'id' => $moduleId,
            'name' => $moduleName,
            'version' => $moduleVersion
        ]);
        
        // Implementirajte logiku koja se treba izvršiti kada je modul aktiviran
    }
    
    /**
     * Slušatelj za događaj deaktivacije modula
     * 
     * @param EventInterface $event
     */
    public function onModuleDeactivated(EventInterface $event): void
    {
        $moduleId = $event->get('id');
        
        $this->logger->modules('Module deactivation event received', [
            'id' => $moduleId
        ]);
        
        // Implementirajte logiku koja se treba izvršiti kada je modul deaktiviran
    }
    
    /**
     * Slušatelj za događaj učitavanja svih modula
     * 
     * @param EventInterface $event
     */
    public function onAllModulesLoaded(EventInterface $event): void
    {
        $modules = $event->get('modules');
        
        $this->logger->modules('All modules loaded event received', [
            'modules_count' => count($modules)
        ]);
        
        // Implementirajte logiku koja se treba izvršiti kada su svi moduli učitani
    }
}