<?php
// app/baseKRIZAN/Modules/ModuleFacade.php

namespace baseKRIZAN\Modules;

use baseKRIZAN\Services\Container;

/**
 * Fasada za lakši pristup funkcionalnostima modula
 * 
 * @package baseKRIZAN\Modules
 */
class ModuleFacade
{
    /**
     * Vraća instancu ModuleManager-a
     */
    public static function getManager(): ModuleManager
    {
        $container = \baseKRIZAN\Bootstrap\Bootstrap::getInstance()->getContainer();
        return $container->get('moduleManager');
    }
    
    /**
     * Provjerava je li modul aktiviran
     * 
     * @param string $moduleId ID modula
     * @return bool
     */
    public static function isEnabled(string $moduleId): bool
    {
        return self::getManager()->isModuleEnabled($moduleId);
    }
    
    /**
     * Aktivira modul
     * 
     * @param string $moduleId ID modula
     * @return bool
     */
    public static function activate(string $moduleId): bool
    {
        return self::getManager()->activateModule($moduleId);
    }
    
    /**
     * Deaktivira modul
     * 
     * @param string $moduleId ID modula
     * @return bool
     */
    public static function deactivate(string $moduleId): bool
    {
        return self::getManager()->deactivateModule($moduleId);
    }
    
    /**
     * Vraća listu aktiviranih modula
     * 
     * @return array
     */
    public static function getEnabledModules(): array
    {
        return self::getManager()->getEnabledModules();
    }
    
    /**
     * Vraća instancu modula prema ID-u
     * 
     * @param string $moduleId ID modula
     * @return ModuleInterface|null
     */
    public static function getModule(string $moduleId): ?ModuleInterface
    {
        return self::getManager()->getModule($moduleId);
    }
    
    /**
     * Emitira događaj vezan uz module
     * 
     * @param string $eventName Ime događaja
     * @param array $data Podaci događaja
     * @return void
     */
    public static function emitEvent(string $eventName, array $data = []): void
    {
        $container = \baseKRIZAN\Bootstrap\Bootstrap::getInstance()->getContainer();
        if ($container->has('eventDispatcher')) {
            $eventDispatcher = $container->get('eventDispatcher');
            $eventDispatcher->dispatch($eventName, $data);
        }
    }
}