<?php
// app/baseKRIZAN/Modules/ModuleInterface.php

namespace baseKRIZAN\Modules;

use baseKRIZAN\Services\Container;
use baseKRIZAN\Error\Logger;
use baseKRIZAN\Events\EventDispatcher;

/**
 * Standardno sučelje za sve module u sustavu
 * 
 * @package baseKRIZAN\Modules
 */
interface ModuleInterface
{
    /**
     * Vraća jedinstveni identifikator modula
     * 
     * @return string
     */
    public function getId(): string;
    
    /**
     * Vraća naziv modula
     * 
     * @return string
     */
    public function getName(): string;
    
    /**
     * Vraća opis modula
     * 
     * @return string
     */
    public function getDescription(): string;
    
    /**
     * Vraća verziju modula
     * 
     * @return string
     */
    public function getVersion(): string;
    
    /**
     * Vraća putanju do direktorija modula
     * 
     * @return string
     */
    public function getPath(): string;
    
    /**
     * Vraća listu zavisnosti modula
     * 
     * @return array Lista ID-ova modula o kojima ovaj modul ovisi
     */
    public function getDependencies(): array;
    
    /**
     * Registrira module u sustavu
     * 
     * @param Container $container DI container
     * @param Logger $logger Logger
     * @param EventDispatcher $eventDispatcher EventDispatcher
     * @return bool True ako je inicijalizacija uspješna, false inače
     */
    public function register(Container $container, Logger $logger, EventDispatcher $eventDispatcher): bool;
    
    /**
     * Inicijalizira modul (učitava ovisnosti i konfiguracijske postavke)
     * 
     * @param Container $container DI container
     * @return bool True ako je inicijalizacija uspješna, false inače
     */
    public function bootstrap(Container $container): bool;
    
    /**
     * Aktivira modul u sustavu
     * 
     * @param Container $container DI container
     * @return bool True ako je aktivacija uspješna, false inače
     */
    public function activate(Container $container): bool;
    
    /**
     * Deaktivira modul u sustavu
     * 
     * @param Container $container DI container
     * @return bool True ako je deaktivacija uspješna, false inače
     */
    public function deactivate(Container $container): bool;
    
    /**
     * Provjerava je li modul aktiviran
     * 
     * @return bool
     */
    public function isEnabled(): bool;
}