<?php
/**
 * Routes Interface - definira sučelje za upravljanje rutama
 *
 * @package baseKRIZAN\Routing
 * @author KRIZAN
 */

namespace baseKRIZAN\Routing;

use baseKRIZAN\Security\Authentication;
use baseKRIZAN\Services\Container;

interface Routes
{
    /**
     * Dohvaća sve registrirane rute
     *
     * @return array Rute
     */
    public function getRoutes(): array;
    
    /**
     * Dohvaća authentication servis
     *
     * @return Authentication Auth servis
     */
    public function getAuthentication(): Authentication;
    
    /**
     * Provjerava ima li korisnik tražene dozvole
     *
     * @param mixed $permission Dozvola za provjeru
     * @return bool True ako korisnik ima dozvolu
     */
    public function checkPermission($permission): bool;
    
    /**
     * Pronalazi i vraća rutu prema zahtjevu
     *
     * @param string $path Putanja zahtjeva
     * @param string $method HTTP metoda
     * @return array|null Pronađena ruta ili null
     */
    public function resolveRoute(string $path, string $method): ?array;
    
    /**
     * Dodaje grupu middleware komponenti
     *
     * @param string $name Naziv grupe
     * @param array $middleware Komponente
     * @return void
     */
    public function addMiddlewareGroup(string $name, array $middleware): void;
    
    /**
     * Dohvaća middleware grupe
     *
     * @return array Middleware grupe
     */
    public function getMiddlewareGroups(): array;
    
    /**
     * Dohvaća URL za imenovanu rutu
     *
     * @param string $name Ime rute
     * @param array $params Parametri za zamjenu u putanji
     * @return string|null URL ili null ako nije pronađeno
     */
    public function getRouteUrl(string $name, array $params = []): ?string;
    
    /**
     * Postavlja container za servise
     *
     * @param Container $container DI container
     * @return void
     */
    public function setContainer(Container $container): void;
    
    /**
     * Čisti cache ruta
     *
     * @return void
     */
    public function clearRouteCache(): void;
}