<?php
// app/baseKRIZAN/Session/SessionHandlerInterface.php

namespace baseKRIZAN\Session;

/**
 * Interface for custom session handlers
 * 
 * Extends PHP's default SessionHandlerInterface with additional methods
 * for managing user sessions
 */
interface SessionHandlerInterface
{
    /**
     * Clean expired sessions for a specific user
     *
     * @param string|int $userId User ID
     * @return bool Success status
     */
    public function cleanExpiredSessionsForUser(string|int $userId): bool;
    
    /**
     * Get all active sessions for a user
     *
     * @param string|int $userId User ID
     * @return array Array of active sessions with metadata
     */
    public function getUserSessions(string|int $userId): array;
    
    /**
     * Delete all sessions for a specific user (logout from all devices)
     *
     * @param string|int $userId User ID
     * @param string|null $exceptSessionId Optional session ID to keep (current session)
     * @return bool Success status
     */
    public function deleteUserSessions(string|int $userId, ?string $exceptSessionId = null): bool;
}