<?php
// app/baseKRIZAN/helpers.php

/**
 * Helper za generiranje URL-a rute
 * 
 * @param string $path Putanja
 * @param array $params Parametri za rutu
 * @param array $queryParams GET parametri
 * @return string URL
 */
function route($path = '', $params = [], $queryParams = []) {
    global $container;
    if (!isset($container) || !$container->has('urlGenerator')) {
        // Fallback ako container nije dostupan
        $basePath = rtrim(\baseKRIZAN\Config\Config::get('paths.app_url'), '/');
        return $basePath . '/' . ltrim($path, '/');
    }
    return $container->get('urlGenerator')->route($path, $params, $queryParams);
}

/**
 * Helper za generiranje URL-a asseta
 * 
 * @param string $path Putanja do asseta
 * @param bool $versioned Dodati verziju za cache busting
 * @return string URL asseta
 */
function asset($path = '', $versioned = true) {
    global $container;
    if (!isset($container) || !$container->has('urlGenerator')) {
        // Fallback ako container nije dostupan
        if (empty($path)) {
            return rtrim(\baseKRIZAN\Config\Config::get('paths.app_url'), '/');
        }
        return \baseKRIZAN\Assets\AssetManager::getAssetPath($path);
    }
    return $container->get('urlGenerator')->asset($path, $versioned);
}