<?php

/**
 * Asset Bundle Configuration
 * Define bundles of CSS and JS files to be combined in production
 */

return [
    'css' => [
        'core' => [
            'output' => 'css/core.bundle.css',
            'files' => [
                'default/css/bootstrap.min.css',
                'default/css/app_theme.css',
                'default/css/app_content.css',
                'default/css/app_layout.css',
                'default/css/app_csrf.css',
                'default/css/app_notifications.css'
            ]
        ],
        'plugins' => [
            'output' => 'css/plugins.bundle.css',
            'files' => [
                'select2/css/select2.min.css',
                'select2/css/select2fix.css',
                'flatpickr/css/flatpickr.min.css',
                'flatpickr/css/dark.css',
                'flatpickr/css/flatpickrfix.css',
                'datatables/css/datatables.min.css',
                'notification/css/notifications.css',
                'notification/css/notification_home.css',
                'datetime/css/tempusdominus-bootstrap-4.min.css',
                'multidatetime/css/multi_tempusdominus-bootstrap-4.min.css',
                'srcassets/datatables/css/datatables-core.css',
                'srcassets/datatables/css/datatables-components.css'
            ]
        ]
    ],
    'js' => [
        'core' => [
            'output' => 'js/core.bundle.js',
            'files' => [
                'default/js/app_global-csp-adapter.js',
                'default/js/jquery-3.7.1.min.js',
                'default/js/app_csrf-jquery.js',
                'default/js/app_csrf-fetch.js',
                'default/js/popper.min.js',
                'default/js/bootstrap.min.js',
                'default/js/app_theme.js',
                'default/js/app_menu-toggle.js'
            ]
        ],
        'plugins' => [
            'output' => 'js/plugins.bundle.js',
            'files' => [
                'select2/js/select2.min.js',
                'select2/js/select2userpermissionsfix.js',
                'flatpickr/js/flatpickr.js',
                'flatpickr/js/hr.js',
                'datatables/js/datatables.min.js',
                'datatables/js/datetime-moment.js',
                'datetime/js/moment.min.js',
                'datetime/js/tempusdominus-bootstrap-4.min.js',
                'multidatetime/js/multi_moment.min.js',
                'multidatetime/js/multi_tempusdominus-bootstrap-4.min.js'
            ]
        ],
        'firebase' => [
            'output' => 'js/firebase.bundle.js',
            'files' => [
                'notification/js/index.js',
                'notification/js/GlobalNotificationHandler.js',
                'notification/js/FirebaseMessagingHandler.js',
                'notification/js/FirebaseRealtimeHandler.js',
                'notification/js/NotificationPageHandler.js',
            ]
        ],
        'datatables-modules' => [
            'output' => 'js/datatables-modules.bundle.js',
            'files' => [
                'srcassets/datatables/js/services/column-service.js',
                'srcassets/datatables/js/services/editor-service.js',
                'srcassets/datatables/js/services/filter-service.js',
                'srcassets/datatables/js/services/format-service.js', 
                'srcassets/datatables/js/services/i18n-service.js',
                'srcassets/datatables/js/services/security-service.js',
                'srcassets/datatables/js/services/theme-service.js',
                'srcassets/datatables/js/core/datatables-core.js',
                'srcassets/datatables/js/datatables-factory.js'
            ]
        ]
    ]
];