<?php

use baseKRIZAN\Assets\AssetManager;

return [
    'default' => [
        'head' => [
            AssetManager::getAssetPath('default/js/app_global-csp-adapter.js'),
            'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css',
            AssetManager::getAssetPath('default/css/bootstrap.min.css'),
            AssetManager::getAssetPath('default/css/app_theme.css'),
            AssetManager::getAssetPath('default/css/app_content.css'),
            AssetManager::getAssetPath('default/css/app_layout.css'),
            AssetManager::getAssetPath('default/css/app_csrf.css'),
            AssetManager::getAssetPath('default/js/jquery-3.7.1.min.js'),
            AssetManager::getAssetPath('default/js/app_csrf-jquery.js'),
            AssetManager::getAssetPath('default/js/app_csrf-fetch.js'),
        ],
        'body' => [
            AssetManager::getAssetPath('default/js/popper.min.js'),
            AssetManager::getAssetPath('default/js/bootstrap.min.js'),
            AssetManager::getAssetPath('default/js/app_theme.js'),
            AssetManager::getAssetPath('default/js/app_menu-toggle.js'),
        ],
    ],
    'notification' => [
        'global' => [
            'head' => [
                // Firebase Core Libraries
                'https://cdnjs.cloudflare.com/ajax/libs/firebase/9.6.1/firebase-app-compat.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/firebase/9.6.1/firebase-auth-compat.min.js',
                
                // Only load these if enabled in configuration
                \baseKRIZAN\Config\Config::get('notifications.fcm_enabled') ? 'https://cdnjs.cloudflare.com/ajax/libs/firebase/9.6.1/firebase-messaging-compat.min.js' : null,
                \baseKRIZAN\Config\Config::get('notifications.realtime_db_enabled') ? 'https://cdnjs.cloudflare.com/ajax/libs/firebase/9.6.1/firebase-database-compat.min.js' : null,
                
                // Notification system CSS
                AssetManager::getAssetPath('notification/css/notifications.css'),
            ],
            'body' => [
                // Centralized Initialization Manager (LOAD FIRST)
                AssetManager::getAssetPath('notification/js/InitializationManager.js'),
                
                // Utility files
                AssetManager::getAssetPath('notification/js/NotificationUtils.js'),
                
                // Core Firebase Initializer
                AssetManager::getAssetPath('notification/js/FirebaseInitializer.js'),
                
                // UI and Badge handlers
                AssetManager::getAssetPath('notification/js/NotificationBadgeHandler.js'),
                
                // Standard Notification Handler
                AssetManager::getAssetPath('notification/js/PushNotificationHandler.js'),
                
                // Conditionally load FCM and Realtime handlers
                \baseKRIZAN\Config\Config::get('notifications.fcm_enabled') ? AssetManager::getAssetPath('notification/js/FCMHandler.js') : null,
                \baseKRIZAN\Config\Config::get('notifications.realtime_db_enabled') ? AssetManager::getAssetPath('notification/js/FirebaseRealtimeHandler.js') : null,
                \baseKRIZAN\Config\Config::get('notifications.realtime_db_enabled') ? AssetManager::getAssetPath('notification/js/RealtimeNotificationHandler.js') : null,
            ],
        ],
        'home' => [
            'head' => [
                AssetManager::getAssetPath('notification/css/notification_home.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('notification/js/notification_home.js'),
            ],
        ],
    ],
    'select2' => [
        'default' => [
            'head' => [
                AssetManager::getAssetPath('select2/css/select2.min.css'),
                AssetManager::getAssetPath('select2/css/select2fix.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('select2/js/select2.min.js'),
            ],
        ],
        'userpermissionsfix' => [
            'body' => [
                AssetManager::getAssetPath('select2/js/select2userpermissionsfix.js'),
            ],
        ],
    ],
    'flatpickr' => [
        'head' => [
            AssetManager::getAssetPath('flatpickr/css/flatpickr.min.css'),
            AssetManager::getAssetPath('flatpickr/css/dark.css'),
            AssetManager::getAssetPath('flatpickr/css/flatpickrfix.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('flatpickr/js/flatpickr.js'),
            AssetManager::getAssetPath('flatpickr/js/hr.js'),
        ],
    ],
    'amcharts' => [
        'body' => [
            AssetManager::getAssetPath('amcharts/js/chart371.min.js'),
        ],
    ],
    'login' => [
        'head' => [
            AssetManager::getAssetPath('login/css/login.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('login/js/login.js'),
        ],
    ],
    'error' => [
        'head' => [
            AssetManager::getAssetPath('error/css/error.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('error/js/error.js'),
        ],
    ],
    'errordev' => [
        'head' => [
            AssetManager::getAssetPath('error/css/errordev.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('error/js/errordev.js'),
        ],
    ],
    'errormodal' => [
        'head' => [
            AssetManager::getAssetPath('errormodal/css/errormodal.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('errormodal/js/errormodal.js'),
        ],
    ],
    'goback' => [
        'body' => [
            AssetManager::getAssetPath('goback/js/goback.js'),
        ],
    ],
    'redirect' => [
        'body' => [
            AssetManager::getAssetPath('redirect/js/redirect.js'),
        ],
    ],
    'home' => [
        'head' => [
            AssetManager::getAssetPath('home/css/home.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('home/js/home.js'),
        ],
    ],
    'cms' => [
        'head' => [
            AssetManager::getAssetPath('cms/css/cms.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('cms/js/cms.js'),
        ],
    ],
    'tables' => [
        'head' => [
            AssetManager::getAssetPath('tables/css/tables.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('tables/js/tables.js'),
        ],
    ],
    'user' => [
        'userslist' => [
            'head' => [
                AssetManager::getAssetPath('user/css/userslist.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('user/js/userslist.js'),
            ],
        ],
        'userpermissions' => [
            'head' => [
                AssetManager::getAssetPath('user/css/userpermissions.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('user/js/userpermissions.js'),
            ],
        ],
        'passwordresetlist' => [
            'body' => [
                AssetManager::getAssetPath('user/js/passwordresetlist.js'),
            ],
        ],
    ],
    'apitoken' => [
        'head' => [
            AssetManager::getAssetPath('apitoken/css/apitoken.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('apitoken/js/apitoken.js'),
        ],
    ],
    'db' => [
        'head' => [
            AssetManager::getAssetPath('dbmanagement/css/dbmanagement.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('dbmanagement/js/dbmanagement.js'),
        ],
    ],
    'luka' => [
        'base' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_base.css'),
            ],
        ],
        'index' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_index.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_index.js'),
            ],
        ],
        'overview' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_overview.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_overview.js'),
            ],
        ],
        'performance' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_performance.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_performance.js'),
            ],
        ],
        'requests' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_requests.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_requests.js'),
            ],
        ],
        'database' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_database.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_database.js'),
            ],
        ],
        'errors' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_errors.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_errors.js'),
            ],
        ],
        'system' => [
            'head' => [
                AssetManager::getAssetPath('LUKA/css/luka_system.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('LUKA/js/luka_system.js'),
            ],
        ],
    ],
    'borna' => [
        'base' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_base.css'),
            ],
        ],
        'index' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_index.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_index.js'),
            ],
        ],
        'overview' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_overview.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_overview.js'),
            ],
        ],
        'firewall' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_firewall.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_firewall.js'),
            ],
        ],
        'blockedips' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_blockedips.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_blockedips.js'),
            ],
        ],
        'security' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_security.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_security.js'),
            ],
        ],
        'settings' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_settings.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_settings.js'),
            ],
        ],
        'reports' => [
            'head' => [
                AssetManager::getAssetPath('BORNA/css/borna_reports.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNA/js/borna_reports.js'),
            ],
        ],
    ],
    'bornatest' => [
        'index' => [
            'head' => [
                AssetManager::getAssetPath('BORNAtest/css/borna_index.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNAtest/js/borna_index.js'),
            ],
        ],
        'performance' => [
            'head' => [
                AssetManager::getAssetPath('BORNAtest/css/borna_performance.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNAtest/js/borna_performance.js'),
            ],
        ],
        'results' => [
            'head' => [
                AssetManager::getAssetPath('BORNAtest/css/borna_results.css'),
            ],
            'body' => [
                AssetManager::getAssetPath('BORNAtest/js/borna_results.js'),
            ],
        ],
    ],

    // I've abandoned these, switched to flatpickr
    'datetime' => [
        'head' => [
            AssetManager::getAssetPath('datetime/css/tempusdominus-bootstrap-4.min.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('datetime/js/moment.min.js'),
            AssetManager::getAssetPath('datetime/js/tempusdominus-bootstrap-4.min.js'),
        ],
    ],
    'multidatetime' => [
        'head' => [
            AssetManager::getAssetPath('multidatetime/css/multi_tempusdominus-bootstrap-4.min.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('multidatetime/js/multi_moment.min.js'),
            AssetManager::getAssetPath('multidatetime/js/multi_tempusdominus-bootstrap-4.min.js'),
        ],
    ],
    // Add other resources as needed
    'datatable' => [
        'head' => [
            AssetManager::getAssetPath('srcassets/datatables/css/base/datatables.min.css'),
            AssetManager::getAssetPath('srcassets/datatables/css/datatables-core.css'),
            AssetManager::getAssetPath('srcassets/datatables/css/datatables-components.css'),
        ],
        'body' => [
            AssetManager::getAssetPath('srcassets/datatables/js/base/datatables.min.js'),
            AssetManager::getAssetPath('srcassets/datatables/js/base/datetime-moment.js'),
        
            // PRVO učitaj module-initializer kao običan script
            AssetManager::getAssetPath('srcassets/datatables/js/module-initializer.js'),

            // Add special attributes for ES module files
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/column-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/editor-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/filter-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/format-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/i18n-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/security-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/services/theme-service.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/core/datatables-core.js'), 'type' => 'module'],
            ['src' => AssetManager::getAssetPath('srcassets/datatables/js/datatables-factory.js'), 'type' => 'module'],
        ],
    ],
];