<?php
// app/config/routes.php

/**
 * Main application routes configuration
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB ROUTES - return HTML pages
// =============================================

// Public web routes (do not require authentication)
$builder->group([
    'middleware' => 'web', 
    'auth' => false
], function($builder) {
    // Home route
    $builder->get('/', ['homeController', 'home']);
    
    // Register routes
    $builder->get('register/user', ['registerController', 'registrationForm']);
    $builder->post('register/user', ['registerController', 'registerUser']);
    $builder->get('verify-email', ['registerController', 'verifyEmail']);
    $builder->get('register/success', ['registerController', 'success']);
    
    // Login routes
    $builder->get('login', ['loginController', 'loginForm']);
    $builder->post('login', ['loginController', 'processLogin']);
    $builder->get('login/error', ['loginController', 'loginError']);
    $builder->get('login/success', ['loginController', 'loginSuccess']);
    $builder->get('logout', ['loginController', 'logout']);
    
    // Password reset routes
    $builder->get('password/reset', ['passwordController', 'passwordresetForm']);
    $builder->post('password/reset', ['passwordController', 'passwordreset']);
    $builder->get('password/confirmreset', ['passwordController', 'confirmpasswordreset']);
    $builder->get('password/update', ['passwordController', 'passwordupdateForm']);
    $builder->post('password/update', ['passwordController', 'passwordupdateForm']);

    // User permissions routes
    $builder->get('user/permissionserror', ['userController', 'permissionsError']);
});

// Notification web routes (UI pages)
$builder->group([
    'middleware' => 'web',
    'auth' => true
], function($builder) {    
    // Chat UI routes
    $builder->get('notification/home', ['notificationController', 'home']);
});

// Admin web routes (UI pages)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_ADMIN
], function($builder) {
    // CMS route
    $builder->get('cms', ['cmsController', 'cms']);

    // Users routes
    $builder->get('users/list', ['userController', 'list']);
    $builder->post('users/list', ['userController', 'list']);
    
    // ADD NEW USER ROUTES
    $builder->get('user/add', ['userController', 'add']);
    $builder->post('user/add', ['userController', 'saveAdd']);
    
    // User permissions routes
    $builder->get('user/permissions/{id:number}', ['userController', 'permissions']);
    $builder->post('user/permissions/{id:number}', ['userController', 'savePermissions']);
    $builder->get('user/permissions', ['userController', 'permissions']);
    $builder->post('user/permissions', ['userController', 'savePermissions']);
    
    // Password management
    $builder->get('password/list', ['passwordController', 'list']);
});

// Master web routes (UI pages for highest permission level)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    
    // Database management routes
    $builder->get('databases/importexport', ['dbmanagementController', 'importExport']);
    $builder->post('databases/importexport', ['dbmanagementController', 'importExport']);
    $builder->get('database/listandedit', ['dbmanagementController', 'listAndEdit']);
    $builder->post('database/listandedit', ['dbmanagementController', 'listAndEdit']);
    $builder->get('database/importexportfull', ['dbmanagementController', 'importExportFull']);
    $builder->post('database/importexportfull', ['dbmanagementController', 'importExportFull']);
});

// LUKA Digital Twin UI routes
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Main dashboard pages
    $builder->get('luka/digital-twin', ['lukaController', 'index']);
    $builder->get('luka/digital-twin/overview', ['lukaController', 'overview']);
    $builder->get('luka/digital-twin/performance', ['lukaController', 'performance']);
    $builder->get('luka/digital-twin/requests', ['lukaController', 'requests']);
    $builder->get('luka/digital-twin/database', ['lukaController', 'database']);
    $builder->get('luka/digital-twin/errors', ['lukaController', 'errors']);
    $builder->get('luka/digital-twin/system', ['lukaController', 'system']);
});

// BORNA Security Module UI routes
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Main security dashboard pages
    $builder->get('borna/security', ['bornaController', 'index']);
    $builder->get('borna/security/overview', ['bornaController', 'overview']);
    $builder->get('borna/security/rules', ['bornaController', 'rules']);
    $builder->get('borna/security/ips', ['bornaController', 'ips']);
    $builder->get('borna/security/events', ['bornaController', 'events']);
    $builder->get('borna/security/settings', ['bornaController', 'settings']);
    $builder->get('borna/security/reports', ['bornaController', 'reports']);
    
    // POST forms for actions
    $builder->post('borna/security/rules', ['bornaController', 'rules']);
    $builder->post('borna/security/ips', ['bornaController', 'ips']);
    $builder->post('borna/security/settings', ['bornaController', 'settings']);
    
    // BORNA Test UI
    $builder->get('borna/security/test', ['bornaTestController', 'index']);
});

// =============================================
// API ROUTES - return JSON data
// =============================================

// Public API routes (do not require authentication)
$builder->group([
    'middleware' => 'api', 
    'auth' => false
], function($builder) {
    // CSP reporting
    $builder->post('csp-report', ['securityController', 'handleCspReport']);
});

// Notification API routes
$builder->group([
    'middleware' => 'api',
    'auth' => true
], function($builder) {    
    // Standard Notification API routes
    $builder->get('notification/api/get-notifications', ['notificationController', 'getNotifications']);
    $builder->post('notification/api/toggle-sticky', ['notificationController', 'toggleSticky']);
    $builder->post('notification/api/mark-as-read', ['notificationController', 'markNotificationsAsRead']);
    $builder->get('notification/api/get-notification-types', ['notificationController', 'getNotificationTypesData']);
    
    // FCM API routes
    $builder->post('fcm/api/save-token', ['fcmController', 'saveToken']);
    $builder->get('fcm/api/get-token', ['fcmController', 'getToken']);
    $builder->get('fcm/api/get-config', ['fcmController', 'getFirebaseConfig']);
    $builder->post('fcm/api/send-test', ['fcmController', 'sendTestNotification']);
    
    // Firebase Realtime Database API routes
    $builder->get('firebase-realtime/api/sync-firebase', ['firebaseRealtimeController', 'syncFirebase']);
    $builder->post('firebase-realtime/api/update-read-status', ['firebaseRealtimeController', 'updateReadStatus']);
    $builder->post('firebase-realtime/api/update-sticky-status', ['firebaseRealtimeController', 'updateStickyStatus']);

    // New Initial Data API endpoint
    $builder->get('api/initial-data', ['initialDataController', 'getInitialData']);
});

// API Token Management Routes - require authentication
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_ADMIN
], function($builder) {
    // API Token endpoints
    $builder->get('api/tokens/list', ['apiTokenController', 'list']);
    $builder->post('api/tokens/generate', ['apiTokenController', 'generate']);
    $builder->post('api/tokens/revoke', ['apiTokenController', 'revoke']);
    $builder->post('api/tokens/revoke-all', ['apiTokenController', 'revokeAll']);
});

// API Token UI routes
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_ADMIN
], function($builder) {
    $builder->get('api/tokens', ['apiTokenController', 'index']);
});

// Master API routes
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // User delete API
    $builder->post('user/delete', ['userController', 'delete']);
});

// LUKA Digital Twin API routes
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // API endpoints
    $builder->get('luka/digital-twin/api/metrics', ['lukaController', 'getMetrics']);
    $builder->get('luka/digital-twin/api/component-metrics', ['lukaController', 'getComponentMetrics']);
    $builder->get('luka/digital-twin/api/state', ['lukaController', 'getState']);
    $builder->post('luka/digital-twin/api/clear-metrics', ['lukaController', 'clearMetrics']);
    $builder->post('luka/digital-twin/api/restart-websocket', ['lukaController', 'restartWebSocket']);
    $builder->get('luka/digital-twin/api/database-queries', ['lukaController', 'getDatabaseQueries']);
    $builder->get('luka/digital-twin/api/system-logs', ['lukaController', 'getSystemLogs']);
    $builder->get('luka/digital-twin/api/websocket-metrics', ['lukaController', 'getWebsocketMetrics']);
});

// BORNA Security Module API routes
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Existing state and attacks routes
    $builder->get('borna/security/api/state', ['bornaController', 'getState']);
    $builder->get('borna/security/api/attacks', ['bornaController', 'getAttacks']);

    // Blocked IPs API routes
    $builder->get('borna/security/api/search-ips', ['bornaController', 'searchIPs']);
    $builder->get('borna/security/api/ip-info', ['bornaController', 'getIPInfo']);

    // Firewall Rules API routes
    $builder->get('borna/security/api/search-rules', ['bornaController', 'searchRules']);
    $builder->post('borna/security/api/rules', ['bornaController', 'createOrUpdateRule']);
    $builder->delete('borna/security/api/rules/{id:number}', ['bornaController', 'deleteRule']);

    // Security Events API routes
    $builder->get('borna/security/api/search-events', ['bornaController', 'searchEvents']);
    $builder->get('borna/security/api/event/{id:number}', ['bornaController', 'getEventDetails']);

    // Settings API routes
    $builder->post('borna/security/api/test-connection', ['bornaController', 'testConnection']);
    $builder->post('borna/security/api/reset-settings', ['bornaController', 'resetSettings']);
    $builder->post('borna/security/api/update-settings', ['bornaController', 'updateSettings']);

    // Reports API routes
    $builder->post('borna/reports/api/generate', ['bornaController', 'generateReport']);
    $builder->post('borna/reports/api/export', ['bornaController', 'exportReport']);

    // BORNA Test API (existing routes)
    $builder->get('borna/security/api/run-test', ['bornaTestController', 'runTest']);
    $builder->get('borna/security/api/get-results', ['bornaTestController', 'getResults']);
    $builder->get('borna/security/api/performance', ['bornaTestController', 'performance']);
});

// Save routes to debug file for verification
$builder->debugRoutes();