<?php
// app/config/env.php
// Uses the global env() function

// Prvo dohvatimo trenutno okruženje
$environment = \baseKRIZAN\Config\Config::get('APP_ENVIRONMENT', 'production');

// Postavke za asset bundling i sourcemaps ovisno o okruženju
$bundlingEnabled = ($environment === 'production') ? true : false;
$sourcemapsEnabled = ($environment === 'production') ? false : true;

return [
    'environment' => \baseKRIZAN\Config\Config::get('APP_ENVIRONMENT', 'production'),
    'owner' => \baseKRIZAN\Config\Config::get('OWNER', 'SHINOBI APPS'),
    'appname' => \baseKRIZAN\Config\Config::get('APP_NAME', 'SHINOBI APPS'),
    'company' => \baseKRIZAN\Config\Config::get('COMPANY', 'SHINOBI APPS'),
    'defaulttimezone' => \baseKRIZAN\Config\Config::get('DEFAULT_TIMEZONE', 'Europe/Zagreb'),
    'email' => [
        'owner' => \baseKRIZAN\Config\Config::get('OWNER_EMAIL', 'nindja21@gmail.com'),
        'admin' => \baseKRIZAN\Config\Config::get('ADMIN_EMAIL', 'numbererikson@gmail.com'),
        'domains' => \baseKRIZAN\Config\Config::get('EMAIL_DOMAINS', 'gmail.com'),
    ],
    'database' => [
        'host' => \baseKRIZAN\Config\Config::get('dbhost', 'localhost'),
        'name' => \baseKRIZAN\Config\Config::get('dbname', 'shinobi_apps'),
        'username' => \baseKRIZAN\Config\Config::get('dbusername', 'root'),
        'password' => \baseKRIZAN\Config\Config::get('dbpassword', ''),
    ],
    'moduli' => \baseKRIZAN\Config\Config::get('ENABLED_MODULES', 'tasks,pm,sales'),
    // Paths
    'paths' => [
        // URL paths
        'app_url' => \baseKRIZAN\Config\Config::get('APP_URL', ''),
        
        // Filesystem paths - all are absolute paths with APP_ROOT prefix
        'root' => APP_ROOT,
        'public' => APP_ROOT . \baseKRIZAN\Config\Config::get('PUBLIC_PATH', '/public'),
        // Config paths
        'config' => APP_ROOT . \baseKRIZAN\Config\Config::get('CONFIG_PATH', '/app/config'),

        // Module paths
        'moduli' => APP_ROOT . \baseKRIZAN\Config\Config::get('MODULES_PATH', '/moduli'),

        // Log paths
        'logs' => APP_ROOT . \baseKRIZAN\Config\Config::get('LOGS_PATH', '/storage/logs'),

        // Views paths
        'resourcesviews' => APP_ROOT . \baseKRIZAN\Config\Config::get('RESOURCESVIEWS_PATH', '/app/resources/views'),
        'cacheviews' => APP_ROOT . \baseKRIZAN\Config\Config::get('CACHEVIEWS_PATH', '/storage/cache/views'),

        // Source asset paths
        'resourcesassets' => APP_ROOT . \baseKRIZAN\Config\Config::get('RESOURCESASSETS_PATH', '/app/resources/assets'),
        'srcassets' => APP_ROOT . \baseKRIZAN\Config\Config::get('SRCASSETS_PATH', '/app/src'),

        // Public asset paths (filesystem)
        'publicappassets' => APP_ROOT . \baseKRIZAN\Config\Config::get('COREASSETS_CACHE_PATH', '/public/appassets'),
        'publicsrcassets' => APP_ROOT . \baseKRIZAN\Config\Config::get('SRCASSETS_CACHE_PATH', '/public/srcassets'),
        'publicmoduliassets' => APP_ROOT . \baseKRIZAN\Config\Config::get('MODULIASSETS_CACHE_PATH', '/public/moduliassets'),

        // Relative URL paths (for web access)
        'publicappassets_relative' => \baseKRIZAN\Config\Config::get('COREASSETS_RELATIVE_PATH', '/appassets'),
        'publicsrcassets_relative' => \baseKRIZAN\Config\Config::get('SRCASSETS_RELATIVE_PATH', '/srcassets'),
        'publicmoduliassets_relative' => \baseKRIZAN\Config\Config::get('MODULIASSETS_RELATIVE_PATH', '/moduliassets'),
    ],
    'authentication' => [
        'enabled' => \baseKRIZAN\Config\Config::get('AUTHENTICATION_ENABLED', true),
    ],
    'api_auth' => [
        'enabled' => \baseKRIZAN\Config\Config::get('API_AUTH_ENABLED', true),
        'token_table' => \baseKRIZAN\Config\Config::get('API_AUTH_TOKEN_TABLE', 'api_tokens'),
        'token_expiration' => \baseKRIZAN\Config\Config::get('API_AUTH_TOKEN_EXPIRATION', 604800),
        'default_scopes' => \baseKRIZAN\Config\Config::get('API_AUTH_DEFAULT_SCOPES', 'read'),
        'cache_enabled' => \baseKRIZAN\Config\Config::get('API_AUTH_CACHE_ENABLED', true),
        'cache_ttl' => \baseKRIZAN\Config\Config::get('API_AUTH_CACHE_TTL', 300),
    ],
    // Logging configuration
    'logging' => [
        'rotation_days' => \baseKRIZAN\Config\Config::get('LOG_ROTATION_DAYS', 30),
        'bootstrap' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_BOOTSTRAP', true),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_BOOTSTRAP', 'DEBUG'),
        ],
        'database' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_DATABASE', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_DATABASE', 'INFO'),
        ],
        'http' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_HTTP', true),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_HTTP', 'DEBUG'),
        ],
        'middleware' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_MIDDLEWARE', true),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_MIDDLEWARE', 'DEBUG'),
        ],
        'routing' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_ROUTING', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_ROUTING', 'DEBUG'),
        ],
        'security' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_SECURITY', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_SECURITY', 'WARNING'),
        ],
        'session' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_SESSION', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_SESSION', 'INFO'),
        ],
        'template' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_TEMPLATE', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_TEMPLATE', 'INFO'),
        ],
        'assets' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_ASSETS', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_ASSETS', 'DEBUG'),
        ],
        'validation' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_VALIDATION', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_VALIDATION', 'INFO'),
        ],
        'services' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_SERVICES', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_SERVICES', 'DEBUG'),
        ],
        'notification' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_NOTIFICATION', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_NOTIFICATION', 'INFO'),
        ],
        'event' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_EVENT', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_EVENT', 'INFO'),
        ],
        'modules' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_MODULES', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_MODULES', 'DEBUG'),
        ],
        'luka' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_LUKA', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_LUKA', 'DEBUG'),
        ],
        'borna' => [
            'enabled' => \baseKRIZAN\Config\Config::get('LOG_BORNA', false),
            'level' => \baseKRIZAN\Config\Config::get('LOG_LEVEL_BORNA', 'DEBUG'),
        ],
    ],
    // Security configuration
    'security' => [
        'csrf' => [
            'excluded' => [
                'routes' => \baseKRIZAN\Config\Config::get('CSRF_EXCLUDED_ROUTES', 'csp-report'),
            ],
        ],
        'ratelimit' => [
            'enabled' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_ENABLED', true),
            'ip_rotation' => [
                'threshold' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_IP_ROTATION_THRESHOLD', 3),
                'timeframe' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_IP_ROTATION_TIMEFRAME', 1800),
                'decay' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_IP_ROTATION_DECAY', 3600),
            ],
            'routes' => [
                'login' => [
                    'max' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_LOGIN_MAX', 5),
                    'window' => \baseKRIZAN\Config\Config::get('RATE_LIMIT_LOGIN_WINDOW', 30),
                ],
                // Add other routes as needed
            ],
        ],
        'headers' => [
            'enabled' => \baseKRIZAN\Config\Config::get('SECURITY_HEADERS_ENABLED', true),
            'csp_report_uri' => \baseKRIZAN\Config\Config::get('CSP_REPORT_URI', '/csp-report'),
            'hsts_max_age' => \baseKRIZAN\Config\Config::get('HSTS_MAX_AGE', '31536000'),
            'xss_protection' => \baseKRIZAN\Config\Config::get('XSS_PROTECTION', '1; mode=block'),
            'content_type_options' => \baseKRIZAN\Config\Config::get('CONTENT_TYPE_OPTIONS', 'nosniff'),
            'frame_options' => \baseKRIZAN\Config\Config::get('FRAME_OPTIONS', 'SAMEORIGIN'),
            'referrer_policy' => \baseKRIZAN\Config\Config::get('REFERRER_POLICY', 'strict-origin-when-cross-origin'),
            'csp' => [
                'default_src' => \baseKRIZAN\Config\Config::get('CSP_DEFAULT_SRC', "'self'"),
                'script_src' => \baseKRIZAN\Config\Config::get('CSP_SCRIPT_SRC', "'self' 'unsafe-inline' 'unsafe-eval' https://cdnjs.cloudflare.com https://*.firebaseio.com https://*.firebasedatabase.app https://*.firebase.com https://*.googleapis.com https://apis.google.com"),
                'style_src' => \baseKRIZAN\Config\Config::get('CSP_STYLE_SRC', "'self' 'unsafe-inline' https://cdnjs.cloudflare.com https://fonts.googleapis.com"),
                'img_src' => \baseKRIZAN\Config\Config::get('CSP_IMG_SRC', "'self' data:"),
                'font_src' => \baseKRIZAN\Config\Config::get('CSP_FONT_SRC', "'self' https://cdnjs.cloudflare.com https://fonts.gstatic.com data:"),
                'connect_src' => \baseKRIZAN\Config\Config::get('CSP_CONNECT_SRC', "'self' https://*.googleapis.com https://*.firebaseio.com https://*.fcmregistrations.googleapis.com https://fcmregistrations.googleapis.com https://firebaseinstallations.googleapis.com wss://*.firebasedatabase.app https://*.firebasedatabase.app https://identitytoolkit.googleapis.com"),
                'frame_src' => \baseKRIZAN\Config\Config::get('CSP_FRAME_SRC', "'self' https://maps.google.com https://*.google.com https://*.gstatic.com https://*.firebasedatabase.app"),
                'frame_ancestors' => \baseKRIZAN\Config\Config::get('CSP_FRAME_ANCESTORS', "'self'"),
                'form_action' => \baseKRIZAN\Config\Config::get('CSP_FORM_ACTION', "'self' https://test.shinobiapps.com"),
            ],
            'permissions_policy' => \baseKRIZAN\Config\Config::get('PERMISSIONS_POLICY', "geolocation=(), microphone=(), camera=(), payment=(), usb=(), accelerometer=(), gyroscope=(), magnetometer=(), midi=(), notifications=self, push=self, sync-xhr=self, interest-cohort=()"),
            'service_worker' => [
                'allow_origin' => '*',
                'allow_methods' => 'GET, OPTIONS',
                'allow_headers' => 'Content-Type, X-CSRF-Token',
                'cache_control' => 'no-store, no-cache, must-revalidate, max-age=0',
                'permissions_policy' => 'notifications=*, push=*'
            ],
        ],
    ],
    // Asset system
    'asset' => [
        'bundling_enabled' => \baseKRIZAN\Config\Config::get('ASSET_BUNDLING_ENABLED', $bundlingEnabled),
        'sourcemaps_enabled' => \baseKRIZAN\Config\Config::get('ASSET_SOURCEMAPS_ENABLED', $sourcemapsEnabled),
        'cdn_enabled' => \baseKRIZAN\Config\Config::get('ASSET_CDN_ENABLED', false),
        'cdn_url' => \baseKRIZAN\Config\Config::get('ASSET_CDN_URL', ''),
        'cdn_types' => \baseKRIZAN\Config\Config::get('ASSET_CDN_TYPES', 'css,js,svg,jpg,jpeg,png,gif,ico,ttf,woff,woff2,eot,otf'),
        'cache_driver' => \baseKRIZAN\Config\Config::get('ASSET_CACHE_DRIVER', 'none'),
        'cache_ttl' => \baseKRIZAN\Config\Config::get('ASSET_CACHE_TTL', 86400),
        'types' => [
            'css' => explode(',', \baseKRIZAN\Config\Config::get('ASSET_TYPES_CSS', 'css')),
            'js' => explode(',', \baseKRIZAN\Config\Config::get('ASSET_TYPES_JS', 'js')),
            'images' => explode(',', \baseKRIZAN\Config\Config::get('ASSET_TYPES_IMAGES', 'jpg,jpeg,png,gif,svg')),
            'fonts' => explode(',', \baseKRIZAN\Config\Config::get('ASSET_TYPES_FONTS', 'ttf,woff,woff2,eot,otf')),
            'other' => explode(',', \baseKRIZAN\Config\Config::get('ASSET_TYPES_OTHER', 'ico')),
        ],
    ],
    // LUKA Digital Twin
    'luka' => [
        // Basic settings
        'enabled' => \baseKRIZAN\Config\Config::get('LUKA_ENABLED', true),
        'debug_mode' => \baseKRIZAN\Config\Config::get('LUKA_DEBUG', false),
        
        // UI settings
        'dashboard_path' => \baseKRIZAN\Config\Config::get('LUKA_DASHBOARD_PATH', '/luka/digital-twin'),
        
        // Sampling settings
        'sampling_rate' => \baseKRIZAN\Config\Config::get('LUKA_SAMPLING_RATE', 100),
        'excluded_routes' => \baseKRIZAN\Config\Config::get('LUKA_EXCLUDED_ROUTES', 'health,ping,status,metrics,prometheus,favicon.ico'),
        'excluded_extensions' => \baseKRIZAN\Config\Config::get('LUKA_EXCLUDED_EXTENSIONS', 'css,js,jpg,jpeg,png,gif,svg,ico,woff,ttf,eot,map'),
        
        // WebSocket settings
        'websocket_enabled' => \baseKRIZAN\Config\Config::get('LUKA_WEBSOCKET_ENABLED', false),
        'websocket_port' => \baseKRIZAN\Config\Config::get('LUKA_WEBSOCKET_PORT', 8080),
        
        // Tracking settings
        'track_database' => \baseKRIZAN\Config\Config::get('LUKA_TRACK_DATABASE', true),
        'track_template' => \baseKRIZAN\Config\Config::get('LUKA_TRACK_TEMPLATE', true),
        'track_session' => \baseKRIZAN\Config\Config::get('LUKA_TRACK_SESSION', true),
        'track_assets' => \baseKRIZAN\Config\Config::get('LUKA_TRACK_ASSETS', true),
        'track_system_logs' => \baseKRIZAN\Config\Config::get('LUKA_TRACK_SYSTEM_LOGS', true),

        // Excluded tables from logging
        'excluded_tables' => explode(',', \baseKRIZAN\Config\Config::get('LUKA_EXCLUDED_TABLES', 'information_schema,security_luka_requests,security_luka_events,security_luka_event_counts,security_luka_summary_stats,security_luka_database_queries,security_luka_system_logs,security_luka_websocket_metrics,security_ratelimit_attempts,security_borna_security_events')),
        
        // Storage settings
        'storage_type' => \baseKRIZAN\Config\Config::get('LUKA_STORAGE_TYPE', 'database'),
        'metrics_retention_days' => \baseKRIZAN\Config\Config::get('LUKA_METRICS_RETENTION_DAYS', 7),
    ],
    // BORNA Security
    'borna' => [
        // Basic configuration
        'enabled' => \baseKRIZAN\Config\Config::get('BORNA_ENABLED', true),
        'debug_mode' => \baseKRIZAN\Config\Config::get('BORNA_DEBUG', false),
        
        // Paths
        'dashboard_path' => \baseKRIZAN\Config\Config::get('BORNA_DASHBOARD_PATH', '/borna/security'),
        
        // Security settings
        'security_level' => \baseKRIZAN\Config\Config::get('BORNA_SECURITY_LEVEL', 2),
        'block_threshold' => \baseKRIZAN\Config\Config::get('BORNA_BLOCK_THRESHOLD', 80),
        'block_duration' => \baseKRIZAN\Config\Config::get('BORNA_BLOCK_DURATION', 24), // sati
        'alert_email' => \baseKRIZAN\Config\Config::get('BORNA_ALERT_EMAIL', ''),
        
        // Logging settings
        'log_attacks' => \baseKRIZAN\Config\Config::get('BORNA_LOG_ATTACKS', true),
        
        // Rate limiting settings
        'rate_limit' => [
            'requests' => \baseKRIZAN\Config\Config::get('BORNA_RATE_LIMIT_REQUESTS', 60),
            'period' => \baseKRIZAN\Config\Config::get('BORNA_RATE_LIMIT_PERIOD', 60), // sekunde
        ],
        
        // Session settings
        'session' => [
            'max_per_user' => \baseKRIZAN\Config\Config::get('BORNA_MAX_SESSIONS_PER_USER', 5),
            'guard_enabled' => \baseKRIZAN\Config\Config::get('BORNA_SESSION_GUARD_ENABLED', true),
        ],
        
        // Attack protection
        'protection' => [
            'xss' => \baseKRIZAN\Config\Config::get('BORNA_XSS_PROTECTION', true),
            'sqli' => \baseKRIZAN\Config\Config::get('BORNA_SQLI_PROTECTION', true),
            'csrf' => \baseKRIZAN\Config\Config::get('BORNA_CSRF_PROTECTION', true),
        ],
        
        // Advanced settings
        'advanced' => [
            'firewall_enabled' => \baseKRIZAN\Config\Config::get('BORNA_FIREWALL_ENABLED', true),
            'auto_block_enabled' => \baseKRIZAN\Config\Config::get('BORNA_AUTO_BLOCK_ENABLED', true),
            'storage_type' => \baseKRIZAN\Config\Config::get('BORNA_STORAGE_TYPE', 'database'),
            'ml_enabled' => \baseKRIZAN\Config\Config::get('BORNA_ML_ENABLED', false),
            'anomaly_detection' => \baseKRIZAN\Config\Config::get('BORNA_ANOMALY_DETECTION', false),
            'integrity_monitoring' => \baseKRIZAN\Config\Config::get('BORNA_INTEGRITY_MONITORING', false),
        ],
        
        // Geolocation settings
        'geolocation' => [
            'protection_enabled' => \baseKRIZAN\Config\Config::get('BORNA_GEO_PROTECTION', false),
            'allowed_countries' => explode(',', \baseKRIZAN\Config\Config::get('BORNA_ALLOWED_COUNTRIES', 'HR')),
            'blocked_countries' => explode(',', \baseKRIZAN\Config\Config::get('BORNA_BLOCKED_COUNTRIES', 'RU,CN,IN')),
        ],
        
        // Redis settings
        'redis' => [
            'host' => \baseKRIZAN\Config\Config::get('BORNA_REDIS_HOST', '127.0.0.1'),
            'port' => \baseKRIZAN\Config\Config::get('BORNA_REDIS_PORT', 6379),
            'password' => \baseKRIZAN\Config\Config::get('BORNA_REDIS_PASSWORD', null),
            'database' => \baseKRIZAN\Config\Config::get('BORNA_REDIS_DATABASE', 0),
        ],
        
        // API protection
        'api_protection' => [
            'rate_limiting' => \baseKRIZAN\Config\Config::get('BORNA_API_RATE_LIMITING', true),
            'jwt_verification' => \baseKRIZAN\Config\Config::get('BORNA_API_JWT_VERIFICATION', true),
            'scope_validation' => \baseKRIZAN\Config\Config::get('BORNA_API_SCOPE_VALIDATION', true),
        ],
        
        // Advanced protections
        'advanced_protection' => [
            'client_fingerprinting' => \baseKRIZAN\Config\Config::get('BORNA_CLIENT_FINGERPRINTING', true),
            'behavioral_biometrics' => \baseKRIZAN\Config\Config::get('BORNA_BEHAVIORAL_BIOMETRICS', false),
            'polymorphic_tokens' => \baseKRIZAN\Config\Config::get('BORNA_POLYMORPHIC_TOKENS', true),
        ],
    ],
    'sessionencrypt' => \baseKRIZAN\Config\Config::get('APP_SECRET', ''),
    'mail' => [
        'host' => \baseKRIZAN\Config\Config::get('MAIL_HOST', 'smtp.gmail.com'),
        'port' => \baseKRIZAN\Config\Config::get('MAIL_PORT', '587'),
        'encryption' => \baseKRIZAN\Config\Config::get('MAIL_ENCRYPTION', 'tls'),
        'username' => \baseKRIZAN\Config\Config::get('MAIL_USERNAME', ''),
        'password' => \baseKRIZAN\Config\Config::get('MAIL_PASSWORD', ''),
        'fromadress' => \baseKRIZAN\Config\Config::get('MAIL_FROM_ADDRESS', 'shinobiapps@gmail.com'),
        'fromname' => \baseKRIZAN\Config\Config::get('MAIL_FROM_NAME', 'SHINOBI APPS'),
    ],
    'notifications' => [
        'fcm_enabled' => (bool)\baseKRIZAN\Config\Config::get('NOTIFICATIONS_FCM_ENABLED', false),
        'realtime_db_enabled' => (bool)\baseKRIZAN\Config\Config::get('NOTIFICATIONS_REALTIME_DB_ENABLED', false),
    ],
    'google' => [
        'firebaseapi' => \baseKRIZAN\Config\Config::get('FIREBASE_API_KEY', ''),
        'firebaseprojid' => \baseKRIZAN\Config\Config::get('FIREBASE_PROJECT_ID', ''),
        'firebasesenderid' => \baseKRIZAN\Config\Config::get('FIREBASE_MESSAGING_SENDER_ID', ''),
        'firebaseappid' => \baseKRIZAN\Config\Config::get('FIREBASE_APP_ID', ''),
        'firebaseserverkey' => \baseKRIZAN\Config\Config::get('FIREBASE_SERVER_KEY', ''),
        'firebaseappcred' => APP_ROOT . \baseKRIZAN\Config\Config::get('GOOGLE_APPLICATION_CREDENTIALS', ''),
        'firebasedatabaseurl' => \baseKRIZAN\Config\Config::get('FIREBASE_DATABASE_URL'),
        'firebasedatabasesecret' => \baseKRIZAN\Config\Config::get('FIREBASE_DATABASE_SECRET', ''),
        'mapsapi' => \baseKRIZAN\Config\Config::get('GOOGLE_API_KEY', ''),
    ],
];