/**
 * BORNA Index Page JavaScript
 * Contains only functionality needed for the main test panel
 */
document.addEventListener('DOMContentLoaded', function() {
  // Initialize test cards with hover effects
  initTestCards();
  
  // Initialize mobile sidebar toggle if needed
  initMobileSidebar();
});

/**
 * Add effects to test cards
 */
function initTestCards() {
  const testItems = document.querySelectorAll('.borna-test-item');
  testItems.forEach(item => {
    item.addEventListener('mouseenter', function() {
      const link = this.querySelector('.borna-test-link');
      if (link) {
        link.style.transition = 'all 0.3s ease';
      }
    });
  });
}

/**
 * Initialize mobile sidebar
 */
function initMobileSidebar() {
  const sidebar = document.querySelector('.borna-sidebar');
  
  // Avoid creating duplicate toggle buttons
  if (!document.querySelector('.borna-mobile-toggle') && sidebar) {
    const mobileToggle = document.createElement('button');
    mobileToggle.className = 'borna-mobile-toggle';
    mobileToggle.innerHTML = '<i class="fas fa-bars"></i>';
    document.body.appendChild(mobileToggle);
    
    // Add click event
    mobileToggle.addEventListener('click', function() {
      sidebar.classList.toggle('show');
      // Change icon based on state
      const icon = this.querySelector('i');
      if (sidebar.classList.contains('show')) {
        icon.className = 'fas fa-times';
      } else {
        icon.className = 'fas fa-bars';
      }
    });
  }
  
  // Close sidebar when clicking outside on mobile
  document.addEventListener('click', function(event) {
    if (!sidebar) return;
    
    const isClickInsideSidebar = sidebar.contains(event.target);
    const isClickOnMobileToggle = event.target.closest('.borna-mobile-toggle');
    
    if (!isClickInsideSidebar && !isClickOnMobileToggle && sidebar.classList.contains('show')) {
      sidebar.classList.remove('show');
      const icon = document.querySelector('.borna-mobile-toggle i');
      if (icon) {
        icon.className = 'fas fa-bars';
      }
    }
  });
}