document.addEventListener('DOMContentLoaded', function() {
  const fileInput = document.getElementById('file');
  const fileNameDisplay = document.getElementById('selected-file-name');
  
  if (fileInput && fileNameDisplay) {
      fileInput.addEventListener('change', function() {
          if (this.files && this.files.length > 0) {
              fileNameDisplay.textContent = this.files[0].name;
              fileNameDisplay.classList.add('has-file');
          } else {
              fileNameDisplay.textContent = 'No file selected';
              fileNameDisplay.classList.remove('has-file');
          }
      });
  }
  
  // Apply theme-aware styling to any danger buttons
  document.addEventListener('themechange', function(e) {
      const theme = e.detail.theme;
      const dangerButtons = document.querySelectorAll('.form-button.danger');
      
      if (theme === 'light') {
          dangerButtons.forEach(btn => {
              btn.style.backgroundColor = '#dc3545';
          });
      } else {
          dangerButtons.forEach(btn => {
              btn.style.backgroundColor = '#e74c3c';
          });
      }
  });
});