// Simple mobile menu dropdown toggle
document.addEventListener('DOMContentLoaded', function() {
  // Select all items that have a dropdown menu
  const menuItems = document.querySelectorAll('.nav-links > li');
  
  menuItems.forEach(item => {
    // Find the clickable element (usually the first a tag)
    const trigger = item.querySelector('a');
    
    // Only process items that have a dropdown menu
    const dropdownMenu = item.querySelector('.dropdown-menu');
    if (!trigger || !dropdownMenu) return;
    
    // Add click event
    trigger.addEventListener('click', function(e) {
      if (window.innerWidth <= 768) { // Only in mobile view
        e.preventDefault();
        
        // Toggle this dropdown
        if (dropdownMenu.style.display === 'block') {
          // If it's open, close it
          dropdownMenu.style.display = 'none';
        } else {
          // Close all other dropdowns first
          document.querySelectorAll('.nav-links > li > .dropdown-menu').forEach(menu => {
            menu.style.display = 'none';
          });
          
          // Open this dropdown
          dropdownMenu.style.display = 'block';
        }
      }
    });
  });
});