// Tab functionality
function setupTabs(tabsContainerId) {
  const tabsContainer = document.getElementById(tabsContainerId);
  if (!tabsContainer) return;
  
  const tabs = tabsContainer.querySelectorAll('.tab');
  
  tabs.forEach(tab => {
      tab.addEventListener('click', () => {
          // Remove active class from all tabs
          tabs.forEach(t => t.classList.remove('active'));
          
          // Add active class to clicked tab
          tab.classList.add('active');
          
          // Hide all tab contents
          const tabContents = document.querySelectorAll('.tab-content');
          tabContents.forEach(content => {
              content.classList.remove('active');
          });
          
          // Show the corresponding tab content
          const tabId = tab.getAttribute('data-tab');
          document.getElementById(tabId).classList.add('active');
      });
  });
}

// Particle effect
function createParticles() {
  const particlesContainer = document.getElementById('particles');
  const particleCount = 20;
  
  for (let i = 0; i < particleCount; i++) {
      const particle = document.createElement('div');
      particle.classList.add('particle');
      
      // Random size
      const size = Math.random() * 5 + 2;
      particle.style.width = `${size}px`;
      particle.style.height = `${size}px`;
      
      // Random position
      particle.style.left = `${Math.random() * 100}%`;
      particle.style.bottom = `-${size}px`;
      
      // Random speed
      const duration = Math.random() * 10 + 15;
      particle.style.animationDuration = `${duration}s`;
      
      // Random delay
      const delay = Math.random() * 10;
      particle.style.animationDelay = `${delay}s`;
      
      // Random opacity
      particle.style.opacity = Math.random() * 0.5 + 0.1;
      
      particlesContainer.appendChild(particle);
  }
}

// Panel actions (minimize, expand, close)
function setupPanelActions() {
  const closeButtons = document.querySelectorAll('.action-close');
  const minimizeButtons = document.querySelectorAll('.action-minimize');
  const expandButtons = document.querySelectorAll('.action-expand');
  
  closeButtons.forEach(button => {
      button.addEventListener('click', () => {
          const panel = button.closest('.panel');
          panel.style.animation = 'fadeIn 0.5s reverse forwards';
          setTimeout(() => {
              panel.style.display = 'none';
          }, 500);
      });
  });
  
  minimizeButtons.forEach(button => {
      button.addEventListener('click', () => {
          const panel = button.closest('.panel');
          const panelBody = panel.querySelector('.panel-body');
          if (panelBody.style.display === 'none') {
              panelBody.style.display = 'block';
          } else {
              panelBody.style.display = 'none';
          }
      });
  });
  
  expandButtons.forEach(button => {
      button.addEventListener('click', () => {
          const panel = button.closest('.panel');
          if (panel.style.maxWidth) {
              panel.style.maxWidth = '';
              panel.style.position = '';
              panel.style.zIndex = '';
              panel.style.width = '';
          } else {
              panel.style.maxWidth = '100%';
              panel.style.position = 'fixed';
              panel.style.zIndex = '100';
              panel.style.top = '20px';
              panel.style.left = '20px';
              panel.style.right = '20px';
              panel.style.width = 'auto';
          }
      });
  });
}

// Terminal typing effect
function typeText(elementId, text, delay = 70) {
  const element = document.getElementById(elementId);
  if (!element) return;
  
  let index = 0;
  element.innerHTML = '';
  
  function type() {
      if (index < text.length) {
          element.innerHTML += text.charAt(index);
          index++;
          setTimeout(type, delay);
      } else {
          // Add blinking cursor at the end
          const cursor = document.createElement('span');
          cursor.className = 'terminal-cursor';
          element.appendChild(cursor);
      }
  }
  
  type();
}

// Collapsible sections
function setupCollapsible() {
  const collapsibles = document.querySelectorAll('.collapsible-header');
  
  collapsibles.forEach(header => {
      header.addEventListener('click', () => {
          const content = header.nextElementSibling;
          if (content.style.maxHeight) {
              content.style.maxHeight = null;
              header.classList.remove('active');
          } else {
              content.style.maxHeight = content.scrollHeight + "px";
              header.classList.add('active');
          }
      });
  });
}

// Initialize everything when the DOM is loaded
document.addEventListener('DOMContentLoaded', () => {
  setupTabs('errorTabs');
  setupTabs('serverTabs');
  createParticles();
  setupPanelActions();
  setupCollapsible();
  
  // Add any typing effects if needed
  // typeText('typingElement', 'System Error Detected...');
});

// Copy to clipboard functionality
function setupCopyButtons() {
  const copyButtons = document.querySelectorAll('.copy-btn');
  
  copyButtons.forEach(button => {
      button.addEventListener('click', () => {
          const textToCopy = button.getAttribute('data-copy');
          navigator.clipboard.writeText(textToCopy)
              .then(() => {
                  button.textContent = 'Copied!';
                  setTimeout(() => {
                      button.textContent = 'Copy';
                  }, 2000);
              })
              .catch(err => {
                  console.error('Could not copy text: ', err);
              });
      });
  });
}

// Handle theme toggle if available
const themeToggle = document.getElementById('theme-toggle');
if (themeToggle) {
  themeToggle.addEventListener('click', () => {
      document.body.classList.toggle('light-theme');
  });
}