function showModal() {
  const modal = document.getElementById("errorModal");
  modal.style.display = "flex";
  // Force a reflow before adding the "show" class to ensure the transition works
  void modal.offsetWidth;
  modal.classList.add("show");
}

function closeModal() {
  const modal = document.getElementById("errorModal");
  modal.classList.remove("show");
  setTimeout(() => {
      modal.style.display = "none";
  }, 300);
}

document.addEventListener("DOMContentLoaded", function() {
  // Add click event to close modal when clicking outside
  const modal = document.getElementById("errorModal");
  if (modal) {
      // Close when clicking on the modal background
      modal.addEventListener("click", function(e) {
          if (e.target === this) {
              closeModal();
          }
      });
      
      // Close when clicking on the X button
      const closeButton = document.getElementById("errorModalClose");
      if (closeButton) {
          closeButton.addEventListener("click", closeModal);
      }
      
      showModal();
  }
});