'use strict';

$(function () {
  // Dodajemo animiranu pozadinu
  createBackgroundAnimation();
  
  // Inicijaliziramo postojeći kod za password vidljivost
  initPasswordVisibility();
  
  // Dodajemo loading efekt na submit
  initFormSubmitEffects();
  
  // Prijavi error modalni prozor temi ako postoji
  const errorModal = document.getElementById('errorModal');
  if (errorModal) {
    window.KrizanUI.applyErrorModalTheme(errorModal);
  }
  
  // Slušamo za promjene teme
  document.addEventListener('themechange', function() {
    // Ako imamo error modal, osvježi ga
    if (errorModal) {
      window.KrizanUI.applyErrorModalTheme(errorModal);
    }
  });
  
  /**
   * Stvara animiranu pozadinu
   */
  function createBackgroundAnimation() {
    // Provjeri postoji li već
    if (document.querySelector('.bg-animation')) return;
    
    const bgAnimation = document.createElement('div');
    bgAnimation.className = 'bg-animation';
    
    // Dodaj 3 oblika
    for (let i = 0; i < 3; i++) {
      const shape = document.createElement('div');
      shape.className = 'shape';
      bgAnimation.appendChild(shape);
    }
    
    document.body.insertBefore(bgAnimation, document.body.firstChild);
    
    // Ako nemamo logo sliku, dodaj ikonu
    const brandDiv = document.querySelector('.brand');
    if (brandDiv && !brandDiv.querySelector('img')) {
      const icon = document.createElement('i');
      icon.className = 'fas fa-shield-alt logo-icon';
      brandDiv.appendChild(icon);
    }
  }
  
  /**
   * Inicijalizira postojeći kod za password vidljivost s vizualnim poboljšanjima
   */
  function initPasswordVisibility() {
    // Ovo je tvoj postojeći kod, samo modificiran za bolji vizualni efekt
    $("input[type='password'][data-eye]").each(function (i) {
      var $this = $(this),
      id = 'eye-password-' + i,
      el = $('#' + id);

      $this.wrap($("<div/>", {
        style: 'position:relative',
        id: id,
        class: 'password-wrapper'
      }));

      $this.css({
        paddingRight: 60
      });
      
      // Promjena u gumbu
      $this.after($("<button/>", {
        html: '<i class="fas fa-eye"></i>',
        class: 'password-toggle-btn',
        id: 'passeye-toggle-' + i,
        type: 'button',
        'aria-label': 'Show password'
      }));

      $this.after($("<input/>", {
        type: 'hidden',
        id: 'passeye-' + i
      }));

      var invalid_feedback = $this.parent().parent().find('.invalid-feedback');

      if (invalid_feedback.length) {
        $this.after(invalid_feedback.clone());
      }

      $this.on("keyup paste", function () {
        $("#passeye-" + i).val($(this).val());
      });
      
      $("#passeye-toggle-" + i).on("click", function (e) {
        e.preventDefault();
        
        if ($this.hasClass("show")) {
          $this.attr('type', 'password');
          $this.removeClass("show");
          $(this).html('<i class="fas fa-eye"></i>');
          $(this).attr('aria-label', 'Show password');
        } else {
          $this.attr('type', 'text');
          $this.val($("#passeye-" + i).val());
          $this.addClass("show");
          $(this).html('<i class="fas fa-eye-slash"></i>');
          $(this).attr('aria-label', 'Hide password');
        }
      });
    });
  }
  
  /**
   * Dodaje animirani loading efekt na submit gumbu
   */
  function initFormSubmitEffects() {
    $(".my-login-validation").submit(function (event) {
      var form = $(this);
      var submitBtn = form.find('button[type="submit"]');
      
      if (form[0].checkValidity() === false) {
        event.preventDefault();
        event.stopPropagation();
      } else {
        // Dodaj loading stanje na gumb
        submitBtn.addClass('loading');
        submitBtn.html('<span>' + submitBtn.text() + '</span>');
      }
      
      form.addClass('was-validated');
    });
  }
});