// Unificirani redirect script za sve stranice
// Ovo zamjenjuje app_redirect.js s konzistentnim pristupom

// Definiraj varijable s default vrijednostima
let action = 'redirect';
let redirectUrl = '';

// Očitaj podatke iz data-atributa, ako postoje
const heroSection = document.querySelector('.hero');
if (heroSection) {
    // Učitaj postavke iz data atributa, ako postoje
    action = heroSection.dataset.redirectAction || action;
    redirectUrl = heroSection.dataset.redirectUrl || redirectUrl;
} else {
    // Koristi prethodno definirane varijable ako postoje (za kompatibilnost)
    // Ovo će se koristiti samo za stranice koje još uvijek koriste stari pristup
    if (typeof redirectAction !== 'undefined') {
        action = redirectAction;
    }
    if (typeof redirectUrl !== 'undefined') {
        redirectUrl = redirectUrl; // Koristi globalnu varijablu ako postoji
    }
}

var seconds = 3;
var countdownElement = document.getElementById('countdown');

console.log('Redirect script loaded with action:', action);
if (action === 'redirect') {
    console.log('Will redirect to:', redirectUrl);
}

// Add visual progress bar
createProgressBar();

function updateCountdown() {
    // Update the number
    if (!countdownElement) return;
    
    countdownElement.textContent = seconds;
    
    // Update progress bar
    updateProgressBar(seconds);

    if (seconds > 0) {
        seconds--;
    } else {
        clearInterval(countdownInterval);
        
        // Add animation before redirecting
        fadeOutAnimation().then(() => {
            if (action === 'back') {
                console.log('Going back to previous page');
                window.history.back();
            } else {
                console.log('Redirecting to:', redirectUrl);
                window.location.href = redirectUrl;
            }
        });
    }
}

// Create visual progress bar
function createProgressBar() {
    if (!countdownElement || !countdownElement.parentNode) return;
    
    // Create container for progress
    const progressContainer = document.createElement('div');
    progressContainer.className = 'countdown-progress-container';
    progressContainer.style.width = '100px';
    progressContainer.style.height = '4px';
    progressContainer.style.backgroundColor = 'rgba(var(--text-secondary-rgb), 0.3)';
    progressContainer.style.borderRadius = '2px';
    progressContainer.style.margin = '10px auto 0';
    progressContainer.style.overflow = 'hidden';
    
    // Create progress bar
    const progressBar = document.createElement('div');
    progressBar.className = 'countdown-progress-bar';
    progressBar.style.width = '100%';
    progressBar.style.height = '100%';
    progressBar.style.backgroundColor = 'var(--accent-primary)';
    progressBar.style.borderRadius = '2px';
    progressBar.style.transition = 'width 1s linear';
    
    // Add to DOM
    progressContainer.appendChild(progressBar);
    countdownElement.parentNode.appendChild(progressContainer);
}

// Update progress bar
function updateProgressBar(secondsLeft) {
    const progressBar = document.querySelector('.countdown-progress-bar');
    if (progressBar) {
        const percentage = (secondsLeft / 3) * 100;
        progressBar.style.width = percentage + '%';
    }
}

// Fade out animation before redirecting
function fadeOutAnimation() {
    return new Promise((resolve) => {
        const content = document.querySelector('.home-content');
        
        if (content) {
            // Fade out animation
            content.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            content.style.opacity = '0';
            content.style.transform = 'scale(0.95)';
            
            // When finished, continue
            setTimeout(() => {
                resolve();
            }, 500);
        } else {
            resolve();
        }
    });
}

// Add visual effect to counter if it exists
if (countdownElement) {
    countdownElement.style.fontWeight = '700';
    countdownElement.style.color = 'var(--accent-primary)';
    countdownElement.style.display = 'inline-block';
    countdownElement.style.minWidth = '30px';
    countdownElement.style.textAlign = 'center';

    // Start countdown
    updateCountdown();
    var countdownInterval = setInterval(updateCountdown, 1000);
}