<?php 
// Load required resources
\baseKRIZAN\Assets\ResourceLoader::loadResource('tables');
\baseKRIZAN\Assets\ResourceLoader::loadResource('apitoken'); 
?>

<div class="container mt-5">
    <h1>API Token Management</h1>
    
    <div class="card mb-4">
        <div class="card-header">
            <h3>Generate New Token</h3>
        </div>
        <div class="card-body">
            <form id="generateTokenForm">
                <div class="mb-3">
                    <label for="tokenDescription" class="form-label">Description</label>
                    <input type="text" class="form-control" id="tokenDescription" name="description" required placeholder="What's this token for?">
                    <small class="text-muted">A description helps you remember what this token is used for.</small>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Scopes</label>
                    <div class="scope-options">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="read" id="scopeRead" name="scopes[]" checked>
                            <label class="form-check-label" for="scopeRead">Read</label>
                            <small class="text-muted d-block ml-4">Access to read-only API endpoints</small>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="write" id="scopeWrite" name="scopes[]">
                            <label class="form-check-label" for="scopeWrite">Write</label>
                            <small class="text-muted d-block ml-4">Access to create and update data</small>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="delete" id="scopeDelete" name="scopes[]">
                            <label class="form-check-label" for="scopeDelete">Delete</label>
                            <small class="text-muted d-block ml-4">Access to delete data</small>
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Generate Token</button>
            </form>
            
            <div id="newTokenDisplay" class="mt-4 d-none">
                <div class="alert alert-success">
                    <h4><i class="fas fa-key"></i> Your New API Token</h4>
                    <p>Please copy your token now. For security reasons, you won't be able to see it again!</p>
                    <div class="input-group">
                        <input type="text" id="newTokenValue" class="form-control" readonly>
                        <button class="btn btn-outline-secondary" type="button" id="copyTokenBtn">
                            <i class="fas fa-copy"></i> Copy
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>Your API Tokens</h3>
            <div class="card-tools">
                <div class="search-container">
                    <i class="fas fa-search"></i>
                    <input type="text" id="tokenSearch" placeholder="Search tokens...">
                </div>
                <button id="revokeAllBtn" class="btn btn-danger btn-sm">
                    <i class="fas fa-trash"></i> Revoke All
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="tokensTable" class="data-table">
                    <thead>
                        <tr>
                            <th class="sortable">Description</th>
                            <th>Scopes</th>
                            <th class="sortable">Created</th>
                            <th class="sortable">Last Used</th>
                            <th class="sortable">Expires</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="tokensList">
                        <tr>
                            <td colspan="6" class="text-center">Loading tokens...</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal" id="deleteModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Revoke Token</h4>
                <button type="button" class="modal-close">&times;</button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to revoke this token? This action cannot be undone.</p>
                <p>Token: <strong id="deleteName"></strong></p>
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST">
                    <input type="hidden" id="deleteId" name="token_id">
                    <button type="button" class="btn btn-secondary modal-cancel">Cancel</button>
                    <button type="submit" class="btn btn-danger">Revoke</button>
                </form>
            </div>
        </div>
    </div>
</div>