<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.security'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Security Events</h2>
      <div class="borna-header-actions">
        <a href="<?= route('borna/security/events') ?>?export=1&format=json" class="borna-btn secondary">
          <i class="fas fa-download"></i> Export JSON
        </a>
        <a href="<?= route('borna/security/events') ?>?export=1&format=csv" class="borna-btn secondary">
          <i class="fas fa-download"></i> Export CSV
        </a>
      </div>
    </div>

    <!-- Filter Controls -->
    <div class="filter-controls">
      <form id="eventsFilterForm" class="filter-form">
        <div class="filter-row">
          <div class="filter-group">
            <label for="from">From Date</label>
            <input type="datetime-local" id="from" name="from" class="borna-form-control" 
                   value="<?= date('Y-m-d\TH:i', strtotime($from)); ?>">
          </div>
          
          <div class="filter-group">
            <label for="to">To Date</label>
            <input type="datetime-local" id="to" name="to" class="borna-form-control" 
                   value="<?= date('Y-m-d\TH:i', strtotime($to)); ?>">
          </div>
          
          <div class="filter-group">
            <label for="eventType">Event Type</label>
            <select id="eventType" name="type" class="borna-form-control">
              <option value="">All Events</option>
              <option value="attack_detected" <?= $eventType === 'attack_detected' ? 'selected' : ''; ?>>Attack Detected</option>
              <option value="ip_blocked" <?= $eventType === 'ip_blocked' ? 'selected' : ''; ?>>IP Blocked</option>
              <option value="ip_unblocked" <?= $eventType === 'ip_unblocked' ? 'selected' : ''; ?>>IP Unblocked</option>
              <option value="rule_triggered" <?= $eventType === 'rule_triggered' ? 'selected' : ''; ?>>Rule Triggered</option>
              <option value="security_level_changed" <?= $eventType === 'security_level_changed' ? 'selected' : ''; ?>>Security Level Changed</option>
            </select>
          </div>
          
          <div class="filter-actions">
            <button type="submit" class="borna-btn primary">
              <i class="fas fa-filter"></i> Apply Filters
            </button>
            <button type="button" id="resetFilters" class="borna-btn secondary">
              <i class="fas fa-sync-alt"></i> Reset
            </button>
          </div>
        </div>
      </form>
    </div>

    <!-- Event Statistics -->
    <div class="events-statistics">
      <div class="stat-cards">
        <?php 
          $totalEvents = array_sum(array_values($eventCounts));
          $attackEvents = $eventCounts['attack_detected'] ?? 0;
          $blockedEvents = $eventCounts['ip_blocked'] ?? 0;
          $unblockedEvents = $eventCounts['ip_unblocked'] ?? 0;
        ?>
        
        <div class="stat-card">
          <div class="stat-icon">
            <i class="fas fa-clipboard-list"></i>
          </div>
          <div class="stat-content">
            <div class="stat-value"><?= number_format($totalEvents); ?></div>
            <div class="stat-label">Total Events</div>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon attack">
            <i class="fas fa-exclamation-triangle"></i>
          </div>
          <div class="stat-content">
            <div class="stat-value"><?= number_format($attackEvents); ?></div>
            <div class="stat-label">Attack Events</div>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon blocked">
            <i class="fas fa-ban"></i>
          </div>
          <div class="stat-content">
            <div class="stat-value"><?= number_format($blockedEvents); ?></div>
            <div class="stat-label">IP Blocks</div>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon unblocked">
            <i class="fas fa-unlock"></i>
          </div>
          <div class="stat-content">
            <div class="stat-value"><?= number_format($unblockedEvents); ?></div>
            <div class="stat-label">IP Unblocks</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Events List -->
    <div class="borna-card">
      <div class="borna-card-header">
        <div class="borna-card-title">
          <i class="fas fa-history"></i> Security Event Log
        </div>
        <div class="borna-card-tools">
          <div class="search-box">
            <input type="text" id="eventsSearch" placeholder="Search events..." class="search-input">
            <i class="fas fa-search"></i>
          </div>
        </div>
      </div>
      <div class="borna-card-body">
        <?php if (empty($events)): ?>
        <div class="empty-state">
          <i class="fas fa-clipboard-check"></i>
          <p>No security events found for the selected time period.</p>
          <button type="button" id="resetFiltersBtn" class="borna-btn primary">
            <i class="fas fa-sync-alt"></i> Reset Filters
          </button>
        </div>
        <?php else: ?>
        <div class="events-table-container">
          <table class="borna-table events-table">
            <thead>
              <tr>
                <th>Time</th>
                <th>Event Type</th>
                <th>IP Address</th>
                <th>Details</th>
                <th class="actions-col">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($events as $event): ?>
              <tr data-event-id="<?= $event['id'] ?? ''; ?>">
                <td>
                  <div class="event-time">
                    <?= date('Y-m-d H:i:s', strtotime($event['timestamp'])); ?>
                  </div>
                  <div class="time-ago">
                    <?= timeAgo(strtotime($event['timestamp'])); ?> ago
                  </div>
                </td>
                <td>
                  <span class="event-badge <?php 
                    $badgeClass = 'info';
                    switch ($event['event_type']) {
                      case 'attack_detected':
                        $badgeClass = 'danger';
                        break;
                      case 'ip_blocked':
                        $badgeClass = 'warning';
                        break;
                      case 'ip_unblocked':
                        $badgeClass = 'success';
                        break;
                      case 'rule_triggered':
                        $badgeClass = 'warning';
                        break;
                      case 'security_level_changed':
                        $badgeClass = 'info';
                        break;
                    }
                    echo $badgeClass;
                  ?>">
                    <i class="fas fa-<?php 
                      $icon = 'info-circle';
                      switch ($event['event_type']) {
                        case 'attack_detected':
                          $icon = 'exclamation-triangle';
                          break;
                        case 'ip_blocked':
                          $icon = 'ban';
                          break;
                        case 'ip_unblocked':
                          $icon = 'unlock';
                          break;
                        case 'rule_triggered':
                          $icon = 'shield-alt';
                          break;
                        case 'security_level_changed':
                          $icon = 'level-up-alt';
                          break;
                      }
                      echo $icon;
                    ?>"></i>
                    <?= str_replace('_', ' ', ucwords($event['event_type'], '_')); ?>
                  </span>
                </td>
                <td>
                  <?php if (isset($event['data']['ip']) && !empty($event['data']['ip'])): ?>
                  <div class="event-ip">
                    <i class="fas fa-laptop"></i> <?= htmlspecialchars($event['data']['ip']); ?>
                  </div>
                  <?php if (isset($event['data']['country']) && !empty($event['data']['country'])): ?>
                  <div class="event-country">
                    <i class="fas fa-globe-americas"></i> <?= htmlspecialchars($event['data']['country']); ?>
                  </div>
                  <?php endif; ?>
                  <?php else: ?>
                  <span class="event-no-ip">-</span>
                  <?php endif; ?>
                </td>
                <td>
                  <?php
                    $details = '';
                    if ($event['event_type'] === 'attack_detected') {
                      $details = 'Score: ' . ($event['data']['score'] ?? 'N/A');
                      if (isset($event['data']['path'])) {
                        $details .= '<br>Path: <span class="event-path">' . htmlspecialchars($event['data']['path']) . '</span>';
                      }
                      if (isset($event['data']['threats']) && is_array($event['data']['threats'])) {
                        $details .= '<br>Threats: ';
                        foreach ($event['data']['threats'] as $index => $threat) {
                          if ($index > 0) $details .= ', ';
                          $details .= '<span class="event-threat">' . htmlspecialchars($threat['type']) . '</span>';
                        }
                      }
                    } elseif ($event['event_type'] === 'ip_blocked') {
                      $details = 'Reason: ' . htmlspecialchars($event['data']['reason'] ?? 'N/A');
                      if (isset($event['data']['duration'])) {
                        $details .= '<br>Duration: ' . ($event['data']['duration'] ?? 'N/A') . ' hours';
                      }
                    } elseif ($event['event_type'] === 'rule_triggered') {
                      $details = 'Rule: ' . htmlspecialchars($event['data']['rule_name'] ?? 'N/A');
                      if (isset($event['data']['action'])) {
                        $details .= '<br>Action: ' . htmlspecialchars($event['data']['action']);
                      }
                    } elseif ($event['event_type'] === 'security_level_changed') {
                      $details = 'Level: ' . ($event['data']['new_level'] ?? 'N/A');
                      if (isset($event['data']['old_level'])) {
                        $details .= ' (from ' . $event['data']['old_level'] . ')';
                      }
                    }
                    echo $details;
                  ?>
                </td>
                <td class="actions-cell">
                  <button type="button" class="borna-btn secondary btn-sm event-details-btn" data-event-id="<?= $event['id'] ?? ''; ?>">
                    <i class="fas fa-eye"></i> Details
                  </button>
                  <?php if ($event['event_type'] === 'attack_detected' && isset($event['data']['ip']) && !empty($event['data']['ip'])): ?>
                  <form action="<?= route('borna/security/ips') ?>" method="post" class="block-ip-form">
                    <input type="hidden" name="action" value="block">
                    <input type="hidden" name="ip" value="<?= htmlspecialchars($event['data']['ip']); ?>">
                    <input type="hidden" name="reason" value="Blocked from security events">
                    <button type="submit" class="borna-btn danger btn-sm">
                      <i class="fas fa-ban"></i> Block
                    </button>
                  </form>
                  <?php endif; ?>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<!-- Event Details Modal -->
<div id="eventDetailsModal" class="borna-modal">
  <div class="borna-modal-content">
    <div class="borna-modal-header">
      <h3>Event Details</h3>
      <button type="button" class="borna-modal-close">&times;</button>
    </div>
    <div class="borna-modal-body">
      <div class="event-details-content">
        <div class="loading-spinner"></div>
        <p>Loading event details...</p>
      </div>
    </div>
  </div>
</div>

<?php
// Helper function to format time ago
function timeAgo($time) {
  $diff = time() - $time;
  
  if ($diff < 60) {
    return $diff . ' seconds';
  } elseif ($diff < 3600) {
    return floor($diff / 60) . ' minutes';
  } elseif ($diff < 86400) {
    return floor($diff / 3600) . ' hours';
  } else {
    return floor($diff / 86400) . ' days';
  }
}
?>