<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.index'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>

        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Security Dashboard</h2>
      <div class="borna-header-status">
        <span class="status-badge <?= $securityStats['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($securityStats['status']); ?>
        </span>
        <span class="security-level level-<?= $securityStats['security_level']; ?>"></span>
        <span>Security Level: <?= $securityStats['security_level']; ?></span>
        <span class="time-display"><?= date('Y-m-d H:i:s'); ?></span>
      </div>
    </div>

    <div class="dashboard-content">
      <div class="quick-actions">
        <h3>Quick Navigation</h3>
        <div class="action-cards">
          <a href="<?= route('borna/security/overview') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-tachometer-alt"></i>
            </div>
            <div class="action-info">
              <h4>Overview</h4>
              <p>Security overview and attack monitoring</p>
            </div>
          </a>
          
          <a href="<?= route('borna/security/rules') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-list-alt"></i>
            </div>
            <div class="action-info">
              <h4>Firewall Rules</h4>
              <p>Manage security rules and filters</p>
            </div>
          </a>
          
          <a href="<?= route('borna/security/ips') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-ban"></i>
            </div>
            <div class="action-info">
              <h4>Blocked IPs</h4>
              <p>Manage IP address restrictions</p>
            </div>
          </a>
          
          <a href="<?= route('borna/security/events') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-history"></i>
            </div>
            <div class="action-info">
              <h4>Security Events</h4>
              <p>View security logs and events</p>
            </div>
          </a>
        </div>
        
        <div class="action-cards">
          <a href="<?= route('borna/security/settings') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-cog"></i>
            </div>
            <div class="action-info">
              <h4>Settings</h4>
              <p>Configure security preferences</p>
            </div>
          </a>
          
          <a href="<?= route('borna/security/reports') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-chart-bar"></i>
            </div>
            <div class="action-info">
              <h4>Reports</h4>
              <p>Generate security analysis reports</p>
            </div>
          </a>
        </div>
      </div>
      
      <div class="security-status">
        <h3>Current Security Status</h3>
        <div class="status-cards">
          <div class="status-card">
            <div class="status-info">
              <h4>Security Level</h4>
              <div class="security-level-display">
                <div class="security-level-indicator level-<?= $securityStats['security_level']; ?>"></div>
                <div class="security-level-label">
                  <?php
                    $levelLabel = 'Low';
                    if ($securityStats['security_level'] == 2) {
                      $levelLabel = 'Medium';
                    } elseif ($securityStats['security_level'] == 3) {
                      $levelLabel = 'High';
                    }
                    echo $levelLabel;
                  ?>
                </div>
              </div>
              <p>Current security policy enforcement level</p>
            </div>
            <div class="status-actions">
              <a href="<?= route('borna/security/settings') ?>" class="borna-btn secondary">
                <i class="fas fa-cog"></i> Change
              </a>
            </div>
          </div>
          
          <div class="status-card">
            <div class="status-info">
              <h4>Firewall Status</h4>
              <div class="status-indicator <?= $securityStats['firewall_status'] === 'active' ? 'active' : 'inactive'; ?>">
                <i class="fas fa-<?= $securityStats['firewall_status'] === 'active' ? 'shield-alt' : 'shield-alt'; ?>"></i>
                <span><?= ucfirst($securityStats['firewall_status']); ?></span>
              </div>
              <p>Web application firewall protection status</p>
            </div>
            <div class="status-actions">
              <a href="<?= route('borna/security/rules') ?>" class="borna-btn secondary">
                <i class="fas fa-list-alt"></i> Rules
              </a>
            </div>
          </div>
          
          <div class="status-card">
            <div class="status-info">
              <h4>Auto-block Status</h4>
              <div class="status-indicator <?= $securityStats['auto_block'] === 'enabled' ? 'active' : 'inactive'; ?>">
                <i class="fas fa-<?= $securityStats['auto_block'] === 'enabled' ? 'check-circle' : 'times-circle'; ?>"></i>
                <span><?= ucfirst($securityStats['auto_block']); ?></span>
              </div>
              <p>Automatic IP blocking for malicious activity</p>
            </div>
            <div class="status-actions">
              <a href="<?= route('borna/security/settings') ?>" class="borna-btn secondary">
                <i class="fas fa-cog"></i> Settings
              </a>
            </div>
          </div>
        </div>
      </div>
      
      <div class="security-metrics">
        <h3>Security Metrics <span class="metrics-timeframe">Last 24 Hours</span></h3>
        <div class="metrics-cards">
          <div class="metric-box">
            <div class="metric-box-icon">
              <i class="fas fa-shield-alt"></i>
            </div>
            <div class="metric-box-data">
              <div class="metric-box-value"><?= number_format($securityStats['attack_count_24h']); ?></div>
              <div class="metric-box-label">Attack Attempts</div>
            </div>
          </div>
          
          <div class="metric-box">
            <div class="metric-box-icon">
              <i class="fas fa-ban"></i>
            </div>
            <div class="metric-box-data">
              <div class="metric-box-value"><?= number_format($securityStats['blocked_ips_count']); ?></div>
              <div class="metric-box-label">Blocked IPs</div>
            </div>
          </div>
          
          <div class="metric-box">
            <div class="metric-box-icon">
              <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="metric-box-data">
              <div class="metric-box-value"><?= number_format($securityStats['high_risk_events'] ?? 0); ?></div>
              <div class="metric-box-label">High Risk Events</div>
            </div>
          </div>
          
          <div class="metric-box">
            <div class="metric-box-icon">
              <i class="fas fa-clipboard-check"></i>
            </div>
            <div class="metric-box-data">
              <div class="metric-box-value"><?= number_format($securityStats['rules_count'] ?? 0); ?></div>
              <div class="metric-box-label">Active Rules</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>