<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.blockedips'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Blocked IP Addresses</h2>
      <div class="borna-header-status">
        <button class="borna-btn primary" id="addBlockBtn">
          <i class="fas fa-plus"></i> Block New IP
        </button>
      </div>
    </div>

    <!-- Notification alerts -->
    <?php if ($blocked): ?>
    <div class="borna-alert success">
      <i class="fas fa-check-circle"></i>
      <div class="alert-content">
        <strong>Success!</strong> IP address has been blocked successfully.
      </div>
    </div>
    <?php endif; ?>
    
    <?php if ($unblocked): ?>
    <div class="borna-alert info">
      <i class="fas fa-info-circle"></i>
      <div class="alert-content">
        <strong>Success!</strong> IP address has been unblocked.
      </div>
    </div>
    <?php endif; ?>

    <div class="ips-content">
      <!-- IP Blocking Form (initially hidden) -->
      <div class="borna-card" id="blockIpForm">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-ban"></i> Block IP Address
          </div>
          <div class="borna-card-tools">
            <button class="borna-btn secondary" id="cancelBlockBtn">
              <i class="fas fa-times"></i> Cancel
            </button>
          </div>
        </div>
        <div class="borna-card-body">
          <form action="<?= route('borna/security/ips') ?>" method="post">
            <input type="hidden" name="action" value="block">
            
            <div class="borna-form-group">
              <label for="ip" class="borna-form-label">IP Address</label>
              <input type="text" id="ip" name="ip" class="borna-form-control" placeholder="e.g. 192.168.1.1" required>
            </div>
            
            <div class="borna-form-group">
              <label for="reason" class="borna-form-label">Reason</label>
              <input type="text" id="reason" name="reason" class="borna-form-control" placeholder="Reason for blocking" required>
            </div>
            
            <div class="borna-form-group">
              <label for="duration" class="borna-form-label">Block Duration (hours)</label>
              <select id="duration" name="duration" class="borna-form-control">
                <option value="1">1 hour</option>
                <option value="6">6 hours</option>
                <option value="12">12 hours</option>
                <option value="24" selected>24 hours</option>
                <option value="48">48 hours</option>
                <option value="72">72 hours</option>
                <option value="168">1 week</option>
                <option value="720">30 days</option>
              </select>
            </div>
            
            <div class="form-actions">
              <button type="submit" class="borna-btn danger">
                <i class="fas fa-ban"></i> Block IP
              </button>
            </div>
          </form>
        </div>
      </div>
      
      <!-- IP List -->
      <div class="borna-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-ban"></i> Currently Blocked IPs
          </div>
          <div class="borna-card-tools">
            <div class="search-container">
              <i class="fas fa-search"></i>
              <input type="text" id="ipSearch" placeholder="Search IPs..." class="search-input">
            </div>
          </div>
        </div>
        <div class="borna-card-body">
          <div class="ip-count-summary">
            <span class="ip-count-label">Total Blocked IPs:</span>
            <span class="ip-count-value"><?= count($blockedIPs); ?></span>
          </div>
          
          <?php if (!empty($blockedIPs)): ?>
          <div class="ip-list">
            <table class="borna-table" id="ipTable">
              <thead>
                <tr>
                  <th>IP Address</th>
                  <th>Reason</th>
                  <th>Blocked On</th>
                  <th>Expires In</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($blockedIPs as $ip => $data): ?>
                <tr>
                  <td>
                    <div class="ip-address">
                      <i class="fas fa-ban"></i>
                      <?= htmlspecialchars($ip); ?>
                    </div>
                  </td>
                  <td><?= htmlspecialchars($data['reason']); ?></td>
                  <td>
                    <?= date('Y-m-d H:i:s', $data['blocked_time']); ?>
                  </td>
                  <td>
                    <?php 
                      $expiresIn = max(0, $data['expires'] - time());
                      $hours = floor($expiresIn / 3600);
                      $minutes = floor(($expiresIn % 3600) / 60);
                      
                      if ($hours > 24) {
                        $days = floor($hours / 24);
                        echo '<span class="expires-badge">' . $days . ' days</span>';
                      } else {
                        echo '<span class="expires-badge">' . $hours . 'h ' . $minutes . 'm</span>';
                      }
                    ?>
                  </td>
                  <td>
                    <form action="<?= route('borna/security/ips') ?>" method="post" class="unblock-form">
                      <input type="hidden" name="action" value="unblock">
                      <input type="hidden" name="ip" value="<?= htmlspecialchars($ip); ?>">
                      <button type="submit" class="borna-btn danger btn-sm unblock-btn">
                        <i class="fas fa-unlock"></i> Unblock
                      </button>
                    </form>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <?php else: ?>
          <div class="empty-state">
            <i class="fas fa-shield-alt"></i>
            <p>No IP addresses are currently blocked.</p>
            <button class="borna-btn primary" id="emptyAddBlockBtn">
              <i class="fas fa-plus"></i> Block an IP Address
            </button>
          </div>
          <?php endif; ?>
        </div>
      </div>
      
      <!-- Information Card -->
      <div class="borna-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-info-circle"></i> About IP Blocking
          </div>
        </div>
        <div class="borna-card-body">
          <div class="info-content">
            <p>IP blocking prevents specific IP addresses from accessing your application. When an IP is blocked:</p>
            
            <ul class="info-list">
              <li>All requests from the IP address will be rejected with a 403 Forbidden response</li>
              <li>The blocking event will be logged in the security events log</li>
              <li>Blocks automatically expire after the configured duration</li>
            </ul>
            
            <div class="info-callout">
              <p><strong>Note:</strong> Blocking an IP address is a temporary security measure. For persistent threats, consider implementing rate limiting or additional security rules.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>