<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.overview'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Security Overview</h2>
      <div class="borna-header-status">
        <span class="status-badge <?= $securityStats['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($securityStats['status']); ?>
        </span>
        <span class="security-level level-<?= $securityStats['security_level']; ?>"></span>
        <span>Security Level: <?= $securityStats['security_level']; ?></span>
        <span class="time-display"><?= date('Y-m-d H:i:s'); ?></span>
      </div>
    </div>

    <div class="overview-content">
      <!-- Metric Cards -->
      <div class="metrics-summary">
        <div class="metric-row">
          <div class="metric-card">
            <div class="metric-label">Blocked IPs</div>
            <div class="metric-value">
              <?= number_format($securityStats['blocked_ips_count']); ?>
            </div>
            <div class="metric-small">Total</div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Attack Attempts</div>
            <div class="metric-value">
              <?= number_format($securityStats['attack_count_24h']); ?>
            </div>
            <div class="metric-small">Last 24h</div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Firewall Status</div>
            <div class="metric-value">
              <i class="fas fa-shield-<?= $securityStats['firewall_status'] === 'active' ? 'check' : 'exclamation'; ?>"></i>
            </div>
            <div class="metric-small"><?= ucfirst($securityStats['firewall_status']); ?></div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Auto-Block</div>
            <div class="metric-value">
              <i class="fas fa-toggle-<?= $securityStats['auto_block'] === 'enabled' ? 'on' : 'off'; ?>"></i>
            </div>
            <div class="metric-small"><?= ucfirst($securityStats['auto_block']); ?></div>
          </div>
        </div>
      </div>
      
      <!-- Attack Chart -->
      <div class="overview-charts">
        <div class="chart-row">
          <div class="borna-card">
            <div class="borna-card-header">
              <div class="borna-card-title">
                <i class="fas fa-chart-bar"></i> Attack Attempts (24h)
              </div>
              <div class="borna-card-tools">
                <button class="borna-btn secondary" id="refreshAttacksChart">
                  <i class="fas fa-sync-alt"></i> Refresh
                </button>
              </div>
            </div>
            <div class="borna-card-body">
              <div class="chart-container">
                <canvas id="attacksChart"></canvas>
              </div>
            </div>
          </div>
          
          <div class="borna-card">
            <div class="borna-card-header">
              <div class="borna-card-title">
                <i class="fas fa-ban"></i> Recent IP Blocks
              </div>
              <div class="borna-card-tools">
                <a href="<?= route('borna/security/ips') ?>" class="borna-btn secondary">
                  <i class="fas fa-eye"></i> View All
                </a>
              </div>
            </div>
            <div class="borna-card-body">
              <ul class="blocked-ips-list">
                <?php if (!empty($blockedIPs)): ?>
                  <?php foreach (array_slice($blockedIPs, 0, 5) as $ip => $data): ?>
                    <li class="blocked-ip-item">
                      <div class="blocked-ip-info">
                        <div class="blocked-ip-address"><?= htmlspecialchars($ip); ?></div>
                        <div class="blocked-ip-reason"><?= htmlspecialchars($data['reason']); ?></div>
                      </div>
                      <div class="blocked-ip-time">
                        <?php 
                          $expiresIn = max(0, $data['expires'] - time());
                          echo floor($expiresIn / 3600) . 'h left';
                        ?>
                      </div>
                    </li>
                  <?php endforeach; ?>
                <?php else: ?>
                  <li class="blocked-ip-empty">No IPs currently blocked</li>
                <?php endif; ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Attack Data Tables -->
      <div class="overview-tables">
        <div class="table-row">
          <div class="borna-card">
            <div class="borna-card-header">
              <div class="borna-card-title">
                <i class="fas fa-map-marker-alt"></i> Top Attacked Paths
              </div>
            </div>
            <div class="borna-card-body">
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>Path</th>
                    <th class="text-center">Count</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($attackedPaths)): ?>
                    <?php foreach ($attackedPaths as $path => $count): ?>
                      <tr>
                        <td><?= htmlspecialchars($path); ?></td>
                        <td class="text-center">
                          <span class="attack-count"><?= $count; ?></span>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="2" class="empty-table">No attack data available</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          
          <div class="borna-card">
            <div class="borna-card-header">
              <div class="borna-card-title">
                <i class="fas fa-user-shield"></i> Top Attacker IPs
              </div>
            </div>
            <div class="borna-card-body">
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>IP Address</th>
                    <th class="text-center">Attacks</th>
                    <th class="text-end">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($activeIPs)): ?>
                    <?php foreach ($activeIPs as $ip => $count): ?>
                      <tr>
                        <td><?= htmlspecialchars($ip); ?></td>
                        <td class="text-center">
                          <span class="attack-count"><?= $count; ?></span>
                        </td>
                        <td class="text-end">
                          <?php if (!isset($blockedIPs[$ip])): ?>
                            <form action="<?= route('borna/security/ips') ?>" method="post" class="d-inline">
                              <input type="hidden" name="action" value="block">
                              <input type="hidden" name="ip" value="<?= htmlspecialchars($ip); ?>">
                              <input type="hidden" name="reason" value="Blocked from overview page">
                              <button type="submit" class="borna-btn danger btn-sm">Block</button>
                            </form>
                          <?php else: ?>
                            <span class="status-badge">Blocked</span>
                          <?php endif; ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="3" class="empty-table">No attacker data available</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Recent Security Events -->
      <div class="borna-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-history"></i> Recent Security Events
          </div>
          <div class="borna-card-tools">
            <a href="<?= route('borna/security/events') ?>" class="borna-btn secondary">
              <i class="fas fa-eye"></i> View All
            </a>
          </div>
        </div>
        <div class="borna-card-body">
          <table class="borna-table">
            <thead>
              <tr>
                <th>Time</th>
                <th>Event Type</th>
                <th>IP</th>
                <th>Details</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($recentEvents)): ?>
                <?php foreach (array_slice($recentEvents, 0, 10) as $event): ?>
                  <tr>
                    <td><?= date('H:i:s', strtotime($event['timestamp'])); ?></td>
                    <td>
                      <span class="event-badge <?php 
                        $badgeClass = 'info';
                        switch ($event['event_type']) {
                          case 'attack_detected':
                            $badgeClass = 'danger';
                            break;
                          case 'ip_blocked':
                            $badgeClass = 'warning';
                            break;
                          case 'ip_unblocked':
                            $badgeClass = 'success';
                            break;
                          case 'security_level_changed':
                            $badgeClass = 'info';
                            break;
                        }
                        echo $badgeClass;
                      ?>">
                        <?= str_replace('_', ' ', ucwords($event['event_type'], '_')); ?>
                      </span>
                    </td>
                    <td><?= htmlspecialchars($event['data']['ip'] ?? '-'); ?></td>
                    <td>
                      <?php
                        $details = '';
                        if ($event['event_type'] === 'attack_detected') {
                          $details = 'Score: ' . ($event['data']['score'] ?? 'N/A');
                          if (isset($event['data']['path'])) {
                            $details .= ', Path: ' . $event['data']['path'];
                          }
                        } elseif ($event['event_type'] === 'ip_blocked') {
                          $details = $event['data']['reason'] ?? 'N/A';
                        } elseif ($event['event_type'] === 'security_level_changed') {
                          $details = 'Level: ' . ($event['data']['new_level'] ?? 'N/A');
                        }
                        echo htmlspecialchars($details);
                      ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php else: ?>
                <tr>
                  <td colspan="4" class="empty-table">No recent security events</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>