<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.reports'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Security Reports</h2>
      <div class="borna-header-status">
        <div class="report-actions">
          <button class="borna-btn primary" id="exportReportBtn">
            <i class="fas fa-download"></i> Export Report
          </button>
          <button class="borna-btn secondary" id="printReportBtn">
            <i class="fas fa-print"></i> Print
          </button>
        </div>
      </div>
    </div>

    <div class="reports-content">
      <!-- Report Filters -->
      <div class="borna-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-filter"></i> Report Filters
          </div>
        </div>
        <div class="borna-card-body">
          <form action="<?= route('borna/security/reports') ?>" method="get" id="reportForm">
            <div class="filters-grid">
              <div class="filter-group">
                <label for="reportType" class="borna-form-label">Report Type</label>
                <select id="reportType" name="type" class="borna-form-control">
                  <option value="security" <?= $reportType === 'security' ? 'selected' : '' ?>>Security Overview</option>
                  <option value="geographic" <?= $reportType === 'geographic' ? 'selected' : '' ?>>Geographic Distribution</option>
                  <option value="threats" <?= $reportType === 'threats' ? 'selected' : '' ?>>Threat Analysis</option>
                </select>
              </div>
              
              <div class="filter-group">
                <label for="from" class="borna-form-label">From Date</label>
                <input type="date" id="from" name="from" class="borna-form-control" value="<?= $from ?>">
              </div>
              
              <div class="filter-group">
                <label for="to" class="borna-form-label">To Date</label>
                <input type="date" id="to" name="to" class="borna-form-control" value="<?= $to ?>">
              </div>
              
              <div class="filter-buttons">
                <button type="submit" class="borna-btn primary">
                  <i class="fas fa-sync-alt"></i> Generate Report
                </button>
                <button type="button" class="borna-btn secondary" id="resetFiltersBtn">
                  <i class="fas fa-undo"></i> Reset
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
      
      <!-- Report Content - Security Overview -->
      <?php if ($reportType === 'security'): ?>
      <div class="borna-card report-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-shield-alt"></i> Security Overview Report
          </div>
          <div class="report-period">
            <?= $from ?> to <?= $to ?>
          </div>
        </div>
        <div class="borna-card-body" id="reportContent">
          <div class="report-summary">
            <div class="summary-metric">
              <div class="metric-icon">
                <i class="fas fa-calendar-alt"></i>
              </div>
              <div class="metric-details">
                <div class="metric-value"><?= $reportData['period_days'] ?></div>
                <div class="metric-label">Days Analyzed</div>
              </div>
            </div>
            
            <div class="summary-metric">
              <div class="metric-icon">
                <i class="fas fa-shield-alt"></i>
              </div>
              <div class="metric-details">
                <div class="metric-value"><?= $reportData['total_events'] ?></div>
                <div class="metric-label">Total Events</div>
              </div>
            </div>
            
            <div class="summary-metric">
              <div class="metric-icon warning">
                <i class="fas fa-exclamation-triangle"></i>
              </div>
              <div class="metric-details">
                <div class="metric-value"><?= $reportData['attack_events'] ?></div>
                <div class="metric-label">Attack Attempts</div>
              </div>
            </div>
            
            <div class="summary-metric">
              <div class="metric-icon danger">
                <i class="fas fa-ban"></i>
              </div>
              <div class="metric-details">
                <div class="metric-value"><?= $reportData['blocked_events'] ?></div>
                <div class="metric-label">IP Blocks</div>
              </div>
            </div>
          </div>
          
          <div class="report-visualization">
            <div class="chart-section">
              <h3>Attack Trends</h3>
              <div class="chart-container">
                <canvas id="attacksChart"></canvas>
              </div>
            </div>
            
            <div class="chart-section">
              <h3>IP Blocking Activity</h3>
              <div class="chart-container">
                <canvas id="blockingChart"></canvas>
              </div>
            </div>
          </div>
          
          <div class="report-insights">
            <h3>Security Insights</h3>
            
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-chart-line"></i>
              </div>
              <div class="insight-content">
                <h4>Attack Trend</h4>
                <?php
                  // Calculate trend
                  $dayCount = count($reportData['attacks_by_day']);
                  $firstHalf = array_slice($reportData['attacks_by_day'], 0, ceil($dayCount/2));
                  $secondHalf = array_slice($reportData['attacks_by_day'], ceil($dayCount/2));
                  
                  $firstHalfAvg = empty($firstHalf) ? 0 : array_sum($firstHalf) / count($firstHalf);
                  $secondHalfAvg = empty($secondHalf) ? 0 : array_sum($secondHalf) / count($secondHalf);
                  
                  $trendPercent = $firstHalfAvg > 0 ? 
                    round((($secondHalfAvg - $firstHalfAvg) / $firstHalfAvg) * 100, 1) : 0;
                    
                  $trendText = $trendPercent > 0 ? 
                    "Attacks have increased by {$trendPercent}% in the second half of the period." : 
                    "Attacks have decreased by " . abs($trendPercent) . "% in the second half of the period.";
                    
                  $trendClass = $trendPercent > 0 ? 'negative' : 'positive';
                ?>
                <p class="<?= $trendClass ?>"><?= $trendText ?></p>
              </div>
            </div>
            
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-shield-alt"></i>
              </div>
              <div class="insight-content">
                <h4>Defense Effectiveness</h4>
                <?php
                  // Calculate effectiveness
                  $effectiveness = $reportData['attack_events'] > 0 ? 
                    round(($reportData['blocked_events'] / $reportData['attack_events']) * 100, 1) : 0;
                    
                  $effectivenessClass = $effectiveness > 80 ? 'positive' : 
                    ($effectiveness > 50 ? 'neutral' : 'negative');
                    
                  $effectivenessText = $effectiveness > 80 ? 
                    "High effectiveness: {$effectiveness}% of attack attempts were blocked." : 
                    ($effectiveness > 50 ? 
                      "Moderate effectiveness: {$effectiveness}% of attack attempts were blocked." : 
                      "Low effectiveness: {$effectiveness}% of attack attempts were blocked.");
                ?>
                <p class="<?= $effectivenessClass ?>"><?= $effectivenessText ?></p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php endif; ?>
      
      <!-- Report Content - Geographic Distribution -->
      <?php if ($reportType === 'geographic'): ?>
      <div class="borna-card report-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-globe"></i> Geographic Distribution Report
          </div>
          <div class="report-period">
            <?= $from ?> to <?= $to ?>
          </div>
        </div>
        <div class="borna-card-body" id="reportContent">
          <div class="report-visualization">
            <div class="chart-section">
              <h3>Attack Origin by Country</h3>
              <div class="chart-container">
                <canvas id="countriesChart"></canvas>
              </div>
            </div>
          </div>
          
          <div class="report-tables">
            <div class="table-section">
              <h3>Top Attack Origins</h3>
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>Country</th>
                    <th>Attack Count</th>
                    <th>Percentage</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                    $totalAttacks = array_sum($reportData['countries']);
                    $i = 0;
                    foreach ($reportData['countries'] as $country => $count):
                      $i++;
                      if ($i > 10) break; // Show top 10
                      $percentage = $totalAttacks > 0 ? round(($count / $totalAttacks) * 100, 1) : 0;
                  ?>
                  <tr>
                    <td><?= htmlspecialchars($country); ?></td>
                    <td><?= number_format($count); ?></td>
                    <td>
                      <div class="percentage-bar">
                        <div class="percentage-fill" data-percent="<?= $percentage ?>"></div>
                        <span class="percentage-text"><?= $percentage ?>%</span>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                  
                  <?php if (empty($reportData['countries'])): ?>
                  <tr>
                    <td colspan="3" class="empty-state">No geographic data available for this period</td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
            
            <div class="table-section">
              <h3>Top Attacking IPs</h3>
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>IP Address</th>
                    <th>Attack Count</th>
                    <th>Percentage</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                    $totalIpAttacks = array_sum($reportData['ips']);
                    $i = 0;
                    foreach ($reportData['ips'] as $ip => $count):
                      $i++;
                      if ($i > 10) break; // Show top 10
                      $percentage = $totalIpAttacks > 0 ? round(($count / $totalIpAttacks) * 100, 1) : 0;
                  ?>
                  <tr>
                    <td><?= htmlspecialchars($ip); ?></td>
                    <td><?= number_format($count); ?></td>
                    <td>
                      <div class="percentage-bar">
                        <div class="percentage-fill" data-percent="<?= $percentage ?>"></div>
                        <span class="percentage-text"><?= $percentage ?>%</span>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                  
                  <?php if (empty($reportData['ips'])): ?>
                  <tr>
                    <td colspan="3" class="empty-state">No IP data available for this period</td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          
          <div class="report-insights">
            <h3>Geographic Insights</h3>
            
            <?php if (!empty($reportData['countries'])): ?>
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-map-marker-alt"></i>
              </div>
              <div class="insight-content">
                <h4>Attack Concentration</h4>
                <?php
                  // Get top country
                  reset($reportData['countries']);
                  $topCountry = key($reportData['countries']);
                  $topCountryCount = current($reportData['countries']);
                  $topCountryPercent = $totalAttacks > 0 ? round(($topCountryCount / $totalAttacks) * 100, 1) : 0;
                  
                  // Count countries with significant attacks (>1%)
                  $significantCountries = 0;
                  foreach ($reportData['countries'] as $count) {
                    if ($totalAttacks > 0 && ($count / $totalAttacks) > 0.01) {
                      $significantCountries++;
                    }
                  }
                ?>
                <p>
                  <?= htmlspecialchars($topCountry) ?> accounts for <?= $topCountryPercent ?>% of all attacks.
                  Attacks originated from <?= count($reportData['countries']) ?> different countries,
                  with <?= $significantCountries ?> countries contributing more than 1% of attacks.
                </p>
              </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($reportData['ips'])): ?>
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-network-wired"></i>
              </div>
              <div class="insight-content">
                <h4>IP Distribution</h4>
                <?php
                  // Get top IP
                  reset($reportData['ips']);
                  $topIp = key($reportData['ips']);
                  $topIpCount = current($reportData['ips']);
                  $topIpPercent = $totalIpAttacks > 0 ? round(($topIpCount / $totalIpAttacks) * 100, 1) : 0;
                  
                  // Determine if attacks are distributed or concentrated
                  $ipConcentration = count($reportData['ips']) > 0 ? 
                    $totalIpAttacks / count($reportData['ips']) : 0;
                  $concentratedAttacks = $ipConcentration > 10;
                  
                  $distributionText = $concentratedAttacks ? 
                    "Attacks show high concentration from specific IPs." : 
                    "Attacks are widely distributed across many IPs.";
                ?>
                <p>
                  The most active IP (<?= htmlspecialchars($topIp) ?>) accounts for <?= $topIpPercent ?>% of all attacks.
                  <?= $distributionText ?>
                </p>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>
      
      <!-- Report Content - Threat Analysis -->
      <?php if ($reportType === 'threats'): ?>
      <div class="borna-card report-card">
        <div class="borna-card-header">
          <div class="borna-card-title">
            <i class="fas fa-bug"></i> Threat Analysis Report
          </div>
          <div class="report-period">
            <?= $from ?> to <?= $to ?>
          </div>
        </div>
        <div class="borna-card-body" id="reportContent">
          <div class="report-visualization">
            <div class="chart-section">
              <h3>Threat Type Distribution</h3>
              <div class="chart-container">
                <canvas id="threatTypeChart"></canvas>
              </div>
            </div>
            
            <div class="chart-section">
              <h3>Most Attacked Paths</h3>
              <div class="chart-container">
                <canvas id="pathsChart"></canvas>
              </div>
            </div>
          </div>
          
          <div class="report-tables">
            <div class="table-section">
              <h3>Threat Types</h3>
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>Threat Type</th>
                    <th>Count</th>
                    <th>Percentage</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                    $totalThreats = array_sum($reportData['threat_types']);
                    foreach ($reportData['threat_types'] as $type => $count):
                      $percentage = $totalThreats > 0 ? round(($count / $totalThreats) * 100, 1) : 0;
                  ?>
                  <tr>
                    <td>
                      <span class="threat-type"><?= ucfirst(htmlspecialchars($type)); ?></span>
                    </td>
                    <td><?= number_format($count); ?></td>
                    <td>
                      <div class="percentage-bar">
                        <div class="percentage-fill" data-percent="<?= $percentage ?>"></div>
                        <span class="percentage-text"><?= $percentage ?>%</span>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                  
                  <?php if (empty($reportData['threat_types'])): ?>
                  <tr>
                    <td colspan="3" class="empty-state">No threat data available for this period</td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
            
            <div class="table-section">
              <h3>Attacked Paths</h3>
              <table class="borna-table">
                <thead>
                  <tr>
                    <th>Path</th>
                    <th>Attack Count</th>
                    <th>Percentage</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                    $totalPathAttacks = array_sum($reportData['paths']);
                    $i = 0;
                    foreach ($reportData['paths'] as $path => $count):
                      $i++;
                      if ($i > 10) break; // Show top 10
                      $percentage = $totalPathAttacks > 0 ? round(($count / $totalPathAttacks) * 100, 1) : 0;
                  ?>
                  <tr>
                    <td class="path-cell"><?= htmlspecialchars($path); ?></td>
                    <td><?= number_format($count); ?></td>
                    <td>
                      <div class="percentage-bar">
                        <div class="percentage-fill" data-percent="<?= $percentage ?>"></div>
                        <span class="percentage-text"><?= $percentage ?>%</span>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                  
                  <?php if (empty($reportData['paths'])): ?>
                  <tr>
                    <td colspan="3" class="empty-state">No path data available for this period</td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          
          <div class="report-insights">
            <h3>Threat Insights</h3>
            
            <?php if (!empty($reportData['threat_types'])): ?>
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-bug"></i>
              </div>
              <div class="insight-content">
                <h4>Dominant Threat Types</h4>
                <?php
                  // Get top threat type
                  reset($reportData['threat_types']);
                  $topThreat = key($reportData['threat_types']);
                  $topThreatCount = current($reportData['threat_types']);
                  $topThreatPercent = $totalThreats > 0 ? round(($topThreatCount / $totalThreats) * 100, 1) : 0;
                  
                  // Get threat diversity
                  $threatTypes = count($reportData['threat_types']);
                ?>
                <p>
                  <?= ucfirst(htmlspecialchars($topThreat)) ?> attacks account for <?= $topThreatPercent ?>% of all threats.
                  The system detected <?= $threatTypes ?> different threat types during this period.
                </p>
              </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($reportData['paths'])): ?>
            <div class="insight-panel">
              <div class="insight-icon">
                <i class="fas fa-map-marker-alt"></i>
              </div>
              <div class="insight-content">
                <h4>Target Analysis</h4>
                <?php
                  // Get top path
                  reset($reportData['paths']);
                  $topPath = key($reportData['paths']);
                  $topPathCount = current($reportData['paths']);
                  $topPathPercent = $totalPathAttacks > 0 ? round(($topPathCount / $totalPathAttacks) * 100, 1) : 0;
                  
                  // Check for admin paths
                  $adminAttacks = 0;
                  $loginAttacks = 0;
                  foreach ($reportData['paths'] as $path => $count) {
                    if (strpos($path, 'admin') !== false) {
                      $adminAttacks += $count;
                    }
                    if (strpos($path, 'login') !== false || strpos($path, 'auth') !== false) {
                      $loginAttacks += $count;
                    }
                  }
                  
                  $adminPercent = $totalPathAttacks > 0 ? round(($adminAttacks / $totalPathAttacks) * 100, 1) : 0;
                  $loginPercent = $totalPathAttacks > 0 ? round(($loginAttacks / $totalPathAttacks) * 100, 1) : 0;
                ?>
                <p>
                  The most targeted path is <code><?= htmlspecialchars($topPath) ?></code> (<?= $topPathPercent ?>% of attacks).
                  <?php if ($adminPercent > 0): ?>
                    Admin-related paths account for <?= $adminPercent ?>% of all attacks.
                  <?php endif; ?>
                  <?php if ($loginPercent > 0): ?>
                    Authentication paths account for <?= $loginPercent ?>% of all attacks.
                  <?php endif; ?>
                </p>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>